/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.util.UniformPrintElementVisitor;

public class DeepPrintElementCounter
extends UniformPrintElementVisitor<AtomicInteger> {
    private static final DeepPrintElementCounter INSTANCE = new DeepPrintElementCounter();

    public static int count(JRPrintElement element) {
        return DeepPrintElementCounter.count(element, (UniformPrintElementVisitor<AtomicInteger>)INSTANCE);
    }

    protected static int count(JRPrintElement element, UniformPrintElementVisitor<AtomicInteger> counter) {
        if (element == null) {
            return 0;
        }
        AtomicInteger count = new AtomicInteger(0);
        element.accept(counter, count);
        return count.get();
    }

    public static int count(Collection<? extends JRPrintElement> elements) {
        return DeepPrintElementCounter.count(elements, (UniformPrintElementVisitor<AtomicInteger>)INSTANCE);
    }

    protected static int count(Collection<? extends JRPrintElement> elements, UniformPrintElementVisitor<AtomicInteger> counter) {
        if (elements == null || elements.isEmpty()) {
            return 0;
        }
        AtomicInteger count = new AtomicInteger(0);
        for (JRPrintElement jRPrintElement : elements) {
            jRPrintElement.accept(counter, count);
        }
        return count.get();
    }

    protected DeepPrintElementCounter() {
        super(true);
    }

    @Override
    protected void visitElement(JRPrintElement element, AtomicInteger count) {
        count.incrementAndGet();
    }
}

