/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.password;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.password.CompromisedPasswordChecker;
import org.springframework.security.authentication.password.CompromisedPasswordDecision;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;

public final class HaveIBeenPwnedRestApiPasswordChecker
implements CompromisedPasswordChecker {
    private static final String API_URL = "https://api.pwnedpasswords.com/range/";
    private static final int PREFIX_LENGTH = 5;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final MessageDigest sha1Digest;
    private RestClient restClient = RestClient.builder().baseUrl("https://api.pwnedpasswords.com/range/").build();

    public HaveIBeenPwnedRestApiPasswordChecker() {
        this.sha1Digest = HaveIBeenPwnedRestApiPasswordChecker.getSha1Digest();
    }

    @NonNull
    public CompromisedPasswordDecision check(String password) {
        byte[] hash = this.sha1Digest.digest(password.getBytes(StandardCharsets.UTF_8));
        String encoded = new String(Hex.encode((byte[])hash)).toUpperCase(Locale.ROOT);
        String prefix = encoded.substring(0, 5);
        String suffix = encoded.substring(5);
        List<String> passwords = this.getLeakedPasswordsForPrefix(prefix);
        boolean isLeaked = this.findLeakedPassword(passwords, suffix);
        return new CompromisedPasswordDecision(isLeaked);
    }

    public void setRestClient(RestClient restClient) {
        Assert.notNull((Object)restClient, (String)"restClient cannot be null");
        this.restClient = restClient;
    }

    private boolean findLeakedPassword(List<String> passwords, String suffix) {
        for (String pw : passwords) {
            if (!pw.startsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private List<String> getLeakedPasswordsForPrefix(String prefix) {
        try {
            String response = (String)this.restClient.get().uri(prefix, new Object[0]).retrieve().body(String.class);
            if (!StringUtils.hasText((String)response)) {
                return Collections.emptyList();
            }
            return response.lines().toList();
        }
        catch (RestClientException ex) {
            this.logger.error((Object)"Request for leaked passwords failed", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    private static MessageDigest getSha1Digest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }
}

