/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import jakarta.servlet.http.HttpServletRequest;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.web.FriendlyCaptchaValidator;
import org.apereo.cas.web.GoogleCaptchaV2Validator;
import org.apereo.cas.web.GoogleCaptchaV3Validator;
import org.apereo.cas.web.HCaptchaValidator;
import org.apereo.cas.web.TurnstileCaptchaValidator;

public interface CaptchaValidator {
    public static CaptchaValidator getInstance(GoogleRecaptchaProperties googleRecaptcha) {
        return switch (googleRecaptcha.getVersion()) {
            default -> throw new MatchException(null, null);
            case GoogleRecaptchaProperties.RecaptchaVersions.GOOGLE_RECAPTCHA_V2 -> new GoogleCaptchaV2Validator(googleRecaptcha);
            case GoogleRecaptchaProperties.RecaptchaVersions.GOOGLE_RECAPTCHA_V3 -> new GoogleCaptchaV3Validator(googleRecaptcha);
            case GoogleRecaptchaProperties.RecaptchaVersions.HCAPTCHA -> new HCaptchaValidator(googleRecaptcha);
            case GoogleRecaptchaProperties.RecaptchaVersions.TURNSTILE -> new TurnstileCaptchaValidator(googleRecaptcha);
            case GoogleRecaptchaProperties.RecaptchaVersions.FRIENDLY_CAPTCHA -> new FriendlyCaptchaValidator(googleRecaptcha);
        };
    }

    public boolean validate(String var1, String var2);

    public String getRecaptchaResponse(HttpServletRequest var1);

    public String getRecaptchaResponseParameterName();

    public GoogleRecaptchaProperties getRecaptchaProperties();
}

