/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.attribute.SimpleUsernameAttributeProvider;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.UsernameAttributeProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlanConfigurer;
import org.apereo.cas.persondir.RestfulPersonAttributeDao;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanContainer;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.http.HttpMethod;

@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.PersonDirectory}, module="rest")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="CasPersonDirectoryRestConfiguration", proxyBeanMethods=false)
class CasPersonDirectoryRestConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasPersonDirectoryRestConfiguration.class);
    private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.attribute-repository.rest[0].url").isUrl();

    CasPersonDirectoryRestConfiguration() {
    }

    @Configuration(value="RestfulAttributeRepositoryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class RestfulAttributeRepositoryPlanConfiguration {
        RestfulAttributeRepositoryPlanConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"restfulPersonDirectoryAttributeRepositoryPlanConfigurer"})
        public PersonDirectoryAttributeRepositoryPlanConfigurer restfulPersonDirectoryAttributeRepositoryPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="restfulAttributeRepositories") BeanContainer<PersonAttributeDao> restfulAttributeRepositories) {
            return (PersonDirectoryAttributeRepositoryPlanConfigurer)BeanSupplier.of(PersonDirectoryAttributeRepositoryPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> {
                List results = restfulAttributeRepositories.toList().stream().filter(PersonAttributeDao::isEnabled).collect(Collectors.toList());
                plan.registerAttributeRepositories(results);
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="RestfulAttributeRepositoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class RestfulAttributeRepositoryConfiguration {
        RestfulAttributeRepositoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"restfulAttributeRepositories"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public BeanContainer<PersonAttributeDao> restfulAttributeRepositories(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (BeanContainer)BeanSupplier.of(BeanContainer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                ArrayList list = new ArrayList();
                casProperties.getAuthn().getAttributeRepository().getRest().stream().filter(rest -> StringUtils.isNotBlank((CharSequence)rest.getUrl())).forEach(rest -> {
                    RestfulPersonAttributeDao dao = new RestfulPersonAttributeDao();
                    dao.setOrder(rest.getOrder());
                    FunctionUtils.doIfNotNull((Object)rest.getId(), id -> dao.setId(new String[]{id}));
                    dao.setUrl(rest.getUrl());
                    dao.setMethod(Objects.requireNonNull(HttpMethod.valueOf((String)rest.getMethod())).name());
                    dao.setEnabled(rest.getState() != AttributeRepositoryStates.DISABLED);
                    Map headers = CollectionUtils.wrap((String)"Content-Type", (Object)"application/json");
                    headers.putAll(rest.getHeaders());
                    dao.setHeaders(headers);
                    dao.setUsernameAttributeProvider((UsernameAttributeProvider)new SimpleUsernameAttributeProvider(rest.getUsernameAttribute()));
                    dao.putTag(PersonDirectoryAttributeRepositoryPlanConfigurer.class.getSimpleName(), (Object)(rest.getState() == AttributeRepositoryStates.ACTIVE ? 1 : 0));
                    if (StringUtils.isNotBlank((CharSequence)rest.getBasicAuthPassword()) && StringUtils.isNotBlank((CharSequence)rest.getBasicAuthUsername())) {
                        dao.setBasicAuthPassword(rest.getBasicAuthPassword());
                        dao.setBasicAuthUsername(rest.getBasicAuthUsername());
                        LOGGER.debug("Basic authentication credentials are located for REST endpoint [{}]", (Object)rest.getUrl());
                    } else {
                        LOGGER.debug("Basic authentication credentials are not defined for REST endpoint [{}]", (Object)rest.getUrl());
                    }
                    LOGGER.debug("Configured REST attribute sources from [{}]", (Object)rest.getUrl());
                    list.add(dao);
                });
                return BeanContainer.of(list);
            }).otherwise(BeanContainer::empty).get();
        }
    }
}

