/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.beans;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class AbstractQuery
implements Serializable {
    private static final long serialVersionUID = -371488230250055359L;
    private Integer page;
    private Integer size;
    private String orderBy;

    @Parameter(name="page", description="page", schema=@Schema(minimum="1", implementation=Integer.class, defaultValue="1"))
    public Integer getPage() {
        return this.page < 1 ? 1 : this.page;
    }

    @Min(value=1L)
    @QueryParam(value="page")
    @DefaultValue(value="1")
    public void setPage(Integer page) {
        this.page = page;
    }

    @Parameter(name="size", description="items per page", schema=@Schema(minimum="1", implementation=Integer.class, defaultValue="25"))
    public Integer getSize() {
        return this.size < 1 ? 1 : this.size;
    }

    @Min(value=1L)
    @QueryParam(value="size")
    @DefaultValue(value="25")
    public void setSize(Integer size) {
        this.size = size;
    }

    @Parameter(name="orderby", description="sorting conditions", schema=@Schema(implementation=String.class, example="key DESC"))
    public String getOrderBy() {
        return this.orderBy;
    }

    @QueryParam(value="orderby")
    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractQuery other = (AbstractQuery)obj;
        return new EqualsBuilder().append((Object)this.page, (Object)other.page).append((Object)this.size, (Object)other.size).append((Object)this.orderBy, (Object)other.orderBy).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.page).append((Object)this.size).append((Object)this.orderBy).build();
    }

    protected static abstract class Builder<Q extends AbstractQuery, B extends Builder<Q, B>> {
        private Q instance;

        protected Builder() {
        }

        protected abstract Q newInstance();

        protected Q getInstance() {
            if (this.instance == null) {
                this.instance = this.newInstance();
            }
            return this.instance;
        }

        public B page(Integer page) {
            ((AbstractQuery)this.getInstance()).setPage(page);
            return (B)this;
        }

        public B size(Integer size) {
            ((AbstractQuery)this.getInstance()).setSize(size);
            return (B)this;
        }

        public B orderBy(String orderBy) {
            ((AbstractQuery)this.getInstance()).setOrderBy(orderBy);
            return (B)this;
        }

        public Q build() {
            return this.getInstance();
        }
    }
}

