/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.functionobjects;

import org.apache.sysds.runtime.functionobjects.KahanPlus;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.KahanObject;

public class COV
extends ValueFunction {
    private static final long serialVersionUID = 1865050401811477181L;
    private static COV singleObj = null;
    private KahanPlus _plus = KahanPlus.getKahanPlusFnObject();

    public static COV getCOMFnObject() {
        if (singleObj == null) {
            singleObj = new COV();
        }
        return singleObj;
    }

    private COV() {
    }

    @Override
    public Data execute(Data in1, double u, double v, double w2) {
        CM_COV_Object cov1 = (CM_COV_Object)in1;
        if (cov1.isCOVAllZeros()) {
            cov1.w = w2;
            cov1.mean.set(u, 0.0);
            cov1.mean_v.set(v, 0.0);
            cov1.c2.set(0.0, 0.0);
            return cov1;
        }
        double w = cov1.w + w2;
        double du = u - cov1.mean._sum;
        double dv = v - cov1.mean_v._sum;
        cov1.mean = (KahanObject)this._plus.execute((Data)cov1.mean, w2 * du / w);
        cov1.mean_v = (KahanObject)this._plus.execute((Data)cov1.mean_v, w2 * dv / w);
        cov1.c2 = (KahanObject)this._plus.execute((Data)cov1.c2, cov1.w * w2 / w * du * dv);
        cov1.w = w;
        return cov1;
    }

    @Override
    public Data execute(Data in1, double u, double v) {
        CM_COV_Object cov1 = (CM_COV_Object)in1;
        if (cov1.isCOVAllZeros()) {
            cov1.w = 1.0;
            cov1.mean.set(u, 0.0);
            cov1.mean_v.set(v, 0.0);
            cov1.c2.set(0.0, 0.0);
            return cov1;
        }
        double w = cov1.w + 1.0;
        double du = u - cov1.mean._sum;
        double dv = v - cov1.mean_v._sum;
        cov1.mean = (KahanObject)this._plus.execute((Data)cov1.mean, du / w);
        cov1.mean_v = (KahanObject)this._plus.execute((Data)cov1.mean_v, dv / w);
        cov1.c2 = (KahanObject)this._plus.execute((Data)cov1.c2, cov1.w / w * du * dv);
        cov1.w = w;
        return cov1;
    }

    @Override
    public Data execute(Data in1, Data in2) {
        CM_COV_Object cov1 = (CM_COV_Object)in1;
        CM_COV_Object cov2 = (CM_COV_Object)in2;
        if (cov1.isCOVAllZeros()) {
            cov1.w = cov2.w;
            cov1.mean.set(cov2.mean);
            cov1.mean_v.set(cov2.mean_v);
            cov1.c2.set(cov2.c2);
            return cov1;
        }
        if (cov2.isCOVAllZeros()) {
            return cov1;
        }
        double w = cov1.w + cov2.w;
        double du = cov2.mean._sum - cov1.mean._sum;
        double dv = cov2.mean_v._sum - cov1.mean_v._sum;
        cov1.mean = (KahanObject)this._plus.execute((Data)cov1.mean, cov2.w * du / w);
        cov1.mean_v = (KahanObject)this._plus.execute((Data)cov1.mean_v, cov2.w * dv / w);
        cov1.c2 = (KahanObject)this._plus.execute(cov1.c2, cov2.c2._sum, cov2.c2._correction);
        cov1.c2 = (KahanObject)this._plus.execute((Data)cov1.c2, cov1.w * cov2.w / w * du * dv);
        cov1.w = w;
        return cov1;
    }
}

