/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.util;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.util.LifeCycleHook;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.server.util.ThreadFactoryUtil;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerGremlinExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ServerGremlinExecutor.class);
    private final GraphManager graphManager;
    private final Settings settings;
    private final List<LifeCycleHook> hooks;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ExecutorService gremlinExecutorService;
    private final GremlinExecutor gremlinExecutor;
    private final DefaultChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final Map<String, Object> hostOptions = new ConcurrentHashMap<String, Object>();
    public final Gauge channelsTotalGauge = MetricManager.INSTANCE.getGauge(this::getChannelCount, MetricRegistry.name(GremlinServer.class, (String[])new String[]{"channels", "total"}));
    public final Gauge channelsPausedGauge = MetricManager.INSTANCE.getGauge(this::getPausedChannelCount, MetricRegistry.name(GremlinServer.class, (String[])new String[]{"channels", "paused"}));

    public ServerGremlinExecutor(Settings settings, ExecutorService gremlinExecutorService, ScheduledExecutorService scheduledExecutorService) {
        ThreadFactory threadFactoryGremlin;
        this.settings = settings;
        try {
            Class<?> clazz = Class.forName(settings.graphManager);
            Constructor<?> c = clazz.getConstructor(Settings.class);
            this.graphManager = (GraphManager)c.newInstance(settings);
        }
        catch (ClassNotFoundException e2) {
            logger.error("Could not find GraphManager implementation defined by the 'graphManager' setting as: {}", (Object)settings.graphManager);
            throw new RuntimeException(e2);
        }
        catch (Exception e3) {
            logger.error("Could not invoke constructor on class {} (defined by the 'graphManager' setting) with one argument of class Settings", (Object)settings.graphManager);
            throw new RuntimeException(e3);
        }
        if (null == gremlinExecutorService) {
            threadFactoryGremlin = ThreadFactoryUtil.create("exec-%d");
            ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(settings.maxWorkQueueSize);
            this.gremlinExecutorService = new ThreadPoolExecutor(settings.gremlinPool, settings.gremlinPool, 0L, TimeUnit.MILLISECONDS, queue, threadFactoryGremlin, new ThreadPoolExecutor.AbortPolicy());
        } else {
            this.gremlinExecutorService = gremlinExecutorService;
        }
        if (null == scheduledExecutorService) {
            threadFactoryGremlin = ThreadFactoryUtil.create("worker-%d");
            this.scheduledExecutorService = Executors.newScheduledThreadPool(settings.threadPoolWorker, threadFactoryGremlin);
        } else {
            this.scheduledExecutorService = scheduledExecutorService;
        }
        logger.info("Initialized Gremlin thread pool.  Threads in pool named with pattern gremlin-*");
        GremlinExecutor.Builder gremlinExecutorBuilder = GremlinExecutor.build().evaluationTimeout(settings.getEvaluationTimeout()).afterFailure((b, e) -> this.graphManager.rollbackAll()).beforeEval(b -> this.graphManager.rollbackAll()).afterTimeout((b, e) -> this.graphManager.rollbackAll()).globalBindings(this.graphManager.getAsBindings()).executorService(this.gremlinExecutorService).scheduledExecutorService(this.scheduledExecutorService);
        settings.scriptEngines.forEach((k, v) -> {
            if (!v.plugins.isEmpty()) {
                gremlinExecutorBuilder.addPlugins(k, v.plugins);
            }
        });
        this.gremlinExecutor = gremlinExecutorBuilder.create();
        logger.info("Initialized GremlinExecutor and preparing GremlinScriptEngines instances.");
        settings.scriptEngines.keySet().forEach(engineName -> {
            try {
                if (!engineName.equals("gremlin-lang")) {
                    GremlinExecutor.LifeCycle lifeCycle = GremlinExecutor.LifeCycle.build().evaluationTimeoutOverride(Long.valueOf(0L)).create();
                    this.gremlinExecutor.eval((Object)"1+1", engineName, (Bindings)new SimpleBindings(Collections.emptyMap()), lifeCycle).join();
                }
                this.registerMetrics((String)engineName);
                logger.info("Initialized {} GremlinScriptEngine and registered metrics", engineName);
            }
            catch (Exception ex) {
                logger.warn(String.format("Could not initialize %s GremlinScriptEngine as init script could not be evaluated", engineName), (Throwable)ex);
            }
        });
        this.gremlinExecutor.getScriptEngineManager().getBindings().entrySet().stream().filter(kv -> kv.getValue() instanceof Graph).forEach(kv -> this.graphManager.putGraph((String)kv.getKey(), (Graph)kv.getValue()));
        this.gremlinExecutor.getScriptEngineManager().getBindings().entrySet().stream().filter(kv -> kv.getValue() instanceof TraversalSource).forEach(kv -> {
            logger.info("A {} is now bound to [{}] with {}", new Object[]{kv.getValue().getClass().getSimpleName(), kv.getKey(), kv.getValue()});
            this.graphManager.putTraversalSource((String)kv.getKey(), (TraversalSource)kv.getValue());
        });
        this.hooks = this.gremlinExecutor.getScriptEngineManager().getBindings().entrySet().stream().filter(kv -> kv.getValue() instanceof LifeCycleHook).map(kv -> (LifeCycleHook)kv.getValue()).collect(Collectors.toList());
    }

    private void registerMetrics(String engineName) {
        GremlinScriptEngine engine = this.gremlinExecutor.getScriptEngineManager().getEngineByName(engineName);
        MetricManager.INSTANCE.registerGremlinScriptEngineMetrics(engine, engineName, "sessionless", "class-cache");
    }

    public void addHostOption(String key, Object value) {
        this.hostOptions.put(key, value);
    }

    public Map<String, Object> getHostOptions() {
        return Collections.unmodifiableMap(this.hostOptions);
    }

    public Object removeHostOption(String key) {
        return this.hostOptions.remove(key);
    }

    public void clearHostOptions() {
        this.hostOptions.clear();
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public GremlinExecutor getGremlinExecutor() {
        return this.gremlinExecutor;
    }

    public ExecutorService getGremlinExecutorService() {
        return this.gremlinExecutorService;
    }

    public GraphManager getGraphManager() {
        return this.graphManager;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public List<LifeCycleHook> getHooks() {
        return this.hooks;
    }

    public DefaultChannelGroup getChannels() {
        return this.channels;
    }

    public long getPausedChannelCount() {
        return this.channels.stream().filter(ch -> !ch.isWritable()).count();
    }

    public long getChannelCount() {
        return this.channels.size();
    }
}

