/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.http;

import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.CallerPrincipal;
import jakarta.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.tomee.security.TomEESecurityContext;

public final class TomEEHttpMessageContext
implements HttpMessageContext {
    private final CallbackHandler handler;
    private final MessageInfo messageInfo;
    private final Subject clientSubject;
    private final Subject serviceSubject;
    private Principal principal;
    private Set<String> groups;

    private TomEEHttpMessageContext(CallbackHandler handler, MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) {
        this.handler = handler;
        this.messageInfo = messageInfo;
        this.clientSubject = clientSubject;
        this.serviceSubject = serviceSubject;
    }

    public static TomEEHttpMessageContext httpMessageContext(CallbackHandler handler, MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) {
        return new TomEEHttpMessageContext(handler, messageInfo, clientSubject, serviceSubject);
    }

    public boolean isProtected() {
        return Boolean.parseBoolean(this.messageInfo.getMap().getOrDefault("jakarta.security.auth.message.MessagePolicy.isMandatory", "false"));
    }

    public boolean isAuthenticationRequest() {
        return Boolean.parseBoolean(this.messageInfo.getMap().getOrDefault("org.apache.tomee.security.context.authenticate", "false"));
    }

    public boolean isRegisterSession() {
        return Boolean.parseBoolean(this.messageInfo.getMap().getOrDefault("jakarta.servlet.http.registerSession", "false"));
    }

    public void setRegisterSession(String callerName, Set<String> groups) {
    }

    public void cleanClientSubject() {
        if (this.clientSubject != null) {
            this.clientSubject.getPrincipals().clear();
        }
    }

    public AuthenticationParameters getAuthParameters() {
        return this.messageInfo.getMap().getOrDefault("org.apache.tomee.security.context.authParams", new AuthenticationParameters());
    }

    public CallbackHandler getHandler() {
        return this.handler;
    }

    public MessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public Subject getClientSubject() {
        return this.clientSubject;
    }

    public HttpServletRequest getRequest() {
        return (HttpServletRequest)this.messageInfo.getRequestMessage();
    }

    public void setRequest(HttpServletRequest request) {
        this.messageInfo.setRequestMessage((Object)request);
    }

    public HttpMessageContext withRequest(HttpServletRequest request) {
        this.setRequest(request);
        return this;
    }

    public HttpServletResponse getResponse() {
        return (HttpServletResponse)this.messageInfo.getResponseMessage();
    }

    public void setResponse(HttpServletResponse response) {
        this.messageInfo.setResponseMessage((Object)response);
    }

    public AuthenticationStatus redirect(String location) {
        try {
            this.getResponse().sendRedirect(location);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return AuthenticationStatus.SEND_CONTINUE;
    }

    public AuthenticationStatus forward(String path) {
        try {
            this.getRequest().getRequestDispatcher(path).forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        }
        catch (ServletException | IOException e) {
            throw new IllegalStateException(e);
        }
        return AuthenticationStatus.SEND_CONTINUE;
    }

    public AuthenticationStatus responseUnauthorized() {
        try {
            this.getResponse().sendError(401);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return AuthenticationStatus.SEND_FAILURE;
    }

    public AuthenticationStatus responseNotFound() {
        try {
            this.getResponse().sendError(404);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return AuthenticationStatus.SEND_FAILURE;
    }

    public AuthenticationStatus notifyContainerAboutLogin(String callername, Set<String> groups) {
        return this.notifyContainerAboutLogin((Principal)new CallerPrincipal(callername), groups);
    }

    public AuthenticationStatus notifyContainerAboutLogin(Principal principal, Set<String> groups) {
        try {
            this.handler.handle(new Callback[]{new CallerPrincipalCallback(this.clientSubject, principal), new GroupPrincipalCallback(this.clientSubject, groups.toArray(new String[groups.size()]))});
        }
        catch (IOException | UnsupportedCallbackException e) {
            e.printStackTrace();
        }
        this.principal = principal;
        this.groups = groups;
        TomEESecurityContext.registerContainerAboutLogin(principal, groups);
        return AuthenticationStatus.SUCCESS;
    }

    public AuthenticationStatus notifyContainerAboutLogin(CredentialValidationResult result) {
        if (result.getStatus().equals((Object)CredentialValidationResult.Status.VALID)) {
            return this.notifyContainerAboutLogin((Principal)result.getCallerPrincipal(), (Set<String>)result.getCallerGroups());
        }
        return AuthenticationStatus.SEND_FAILURE;
    }

    public AuthenticationStatus doNothing() {
        this.principal = null;
        this.groups = null;
        try {
            this.handler.handle(new Callback[]{new CallerPrincipalCallback(this.clientSubject, (String)null), new GroupPrincipalCallback(this.clientSubject, null)});
        }
        catch (IOException | UnsupportedCallbackException e) {
            e.printStackTrace();
        }
        TomEESecurityContext.registerContainerAboutLogin((Principal)new CallerPrincipal(null), null);
        return AuthenticationStatus.NOT_DONE;
    }

    public Principal getCallerPrincipal() {
        return this.principal;
    }

    public Set<String> getGroups() {
        return this.groups;
    }
}

