/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.NonnullFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.slf4j.Logger;

public final class CollectionSupport {
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(CollectionSupport.class);

    private CollectionSupport() {
    }

    @Nonnull
    public static <T> BinaryOperator<T> warningMergeFunction(final String what, final boolean takeFirst) {
        return new BinaryOperator<T>(){

            @Override
            public T apply(T current, T lookingAt) {
                log.warn("Duplicate detected building {}", (Object)what);
                log.debug("Values provided are {} and {} taking {}", new Object[]{current, lookingAt, takeFirst ? "first" : "last"});
                return takeFirst ? current : lookingAt;
            }
        };
    }

    public static <T, A, R> Collector<T, A, NonnullSupplier<R>> nonnullCollector(Collector<T, A, R> collector) {
        NonnullFunction func = new NonnullFunction<R, NonnullSupplier<R>>(){

            @Override
            @Nonnull
            public NonnullSupplier<R> apply(@Nullable R input) {
                return NonnullSupplier.of(Constraint.isNotNull(input, "Null result from collector"));
            }
        };
        return Collectors.collectingAndThen(collector, func);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> List<T> singletonList(@Nonnull T item) {
        return Collections.singletonList(item);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> List<T> listOf() {
        return List.of();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> List<T> listOf(@Nonnull T first) {
        return List.of(first);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> List<T> listOf(@Nonnull T first, @Nonnull T second) {
        return List.of(first, second);
    }

    @SafeVarargs
    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> List<T> listOf(T ... elements) {
        return List.of(elements);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> List<T> copyToList(@Nonnull Collection<? extends T> coll) {
        return List.copyOf(coll);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> Set<T> emptySet() {
        return Collections.emptySet();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> Set<T> singleton(@Nonnull T item) {
        return Collections.singleton(item);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> Set<T> setOf() {
        return Set.of();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> Set<T> setOf(@Nonnull T first) {
        return Set.of(first);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> Set<T> setOf(@Nonnull T first, @Nonnull T second) {
        return Set.of(first, second);
    }

    @SafeVarargs
    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> Set<T> setOf(T ... elements) {
        return Set.of(elements);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> Set<T> copyToSet(@Nonnull Collection<? extends T> coll) {
        return Set.copyOf(coll);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T, U> Map<T, U> emptyMap() {
        return Collections.emptyMap();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T, U> Map<T, U> singletonMap(@Nonnull T key, @Nullable U value) {
        return Collections.singletonMap(key, value);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static <U, T> Map<U, T> copyToMap(@Nonnull Map<? extends U, ? extends T> map) {
        return Map.copyOf(map);
    }

    @SafeVarargs
    @Nonnull
    @Unmodifiable
    @NotLive
    public static <T> List<T> arrayAsList(T ... a) {
        return Arrays.asList(a);
    }
}

