/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.turbine;

import java.util.Set;
import org.apache.fulcrum.security.GroupManager;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.ACLFactory;
import org.apache.fulcrum.security.model.turbine.TurbineAccessControlList;
import org.apache.fulcrum.security.model.turbine.TurbineAccessControlListImpl;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUser;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class TurbineACLFactory
extends AbstractManager
implements ACLFactory {
    @Override
    public <T extends AccessControlList> T getAccessControlList(User user) {
        TurbineUser tu = (TurbineUser)user;
        Set tugr = tu.getUserGroupRoleSet();
        try {
            TurbineAccessControlList aclInstance = this.getAclInstance(tugr);
            return (T)aclInstance;
        }
        catch (UnknownEntityException uue) {
            throw new RuntimeException(uue.getMessage(), uue);
        }
    }

    private TurbineAccessControlList getAclInstance(Set<? extends TurbineUserGroupRole> turbineUserGroupRoleSet) throws UnknownEntityException {
        TurbineAccessControlListImpl accessControlList;
        GroupManager groupManager;
        block8: {
            groupManager = null;
            try {
                groupManager = this.getGroupManager();
                if (groupManager == null) break block8;
                Group g = null;
                try {
                    g = groupManager.getGroupByName("global");
                }
                catch (UnknownEntityException uee) {
                    g = groupManager.getGroupInstance("global");
                    try {
                        groupManager.addGroup(g);
                    }
                    catch (EntityExistsException eee) {
                        throw new DataBackendException(eee.getMessage(), eee);
                    }
                }
            }
            catch (DataBackendException e) {
                // empty catch block
            }
        }
        try {
            accessControlList = new TurbineAccessControlListImpl(turbineUserGroupRoleSet, groupManager);
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate an ACL implementation object", e);
        }
        return accessControlList;
    }
}

