/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class DuccNodes {
    private static DuccLogger logger = DuccLogger.getLogger(DuccNodes.class);
    private static DuccId jobid = null;
    private static DuccNodes duccNodes = new DuccNodes();
    private boolean sysout = false;

    public static DuccNodes getInstance() {
        return duccNodes;
    }

    public static DuccNodes getSysOutInstance() {
        DuccNodes retVal = new DuccNodes();
        retVal.sysout = true;
        return retVal;
    }

    private void warn(String location, DuccId jobid, String text) {
        if (this.sysout) {
            System.out.println(location + " " + text);
        } else {
            logger.warn(location, jobid, new Object[]{text});
        }
    }

    private void trace(String location, DuccId jobid, String text) {
        if (this.sysout) {
            System.out.println(location + " " + text);
        } else {
            logger.trace(location, jobid, new Object[]{text});
        }
    }

    private void ignore(String fileName, String reason) {
        String location = "ignore";
        String text = "file:" + fileName + " reason:" + reason;
        this.warn(location, jobid, text);
    }

    private void ignore(String fileName, int lineno, String line, String reason) {
        String location = "ignore";
        String text = "file:" + fileName + " #" + lineno + " " + line + " reason:" + reason;
        this.warn(location, jobid, text);
    }

    private void duplicate(String fileName, int lineno, String line) {
        String location = "duplicate";
        String text = "file:" + fileName + " #" + lineno + " " + line;
        this.trace(location, jobid, text);
    }

    private NodeSet get(String dirResources, String fileName, NodeSet nodeSet) {
        String filePath = fileName;
        if (!fileName.startsWith(File.separator)) {
            filePath = dirResources + fileName;
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filePath));
            int lineno = 0;
            while ((line = in.readLine()) != null) {
                String value;
                ++lineno;
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                String[] nvp = line.split(" ");
                if (nvp.length == 1) {
                    value = nvp[0].trim();
                    if (value.equals("import")) {
                        this.ignore(filePath, lineno, line, "import file missing");
                        continue;
                    }
                    if (nodeSet.nodes.contains(value)) {
                        this.duplicate(filePath, lineno, line);
                        continue;
                    }
                    nodeSet.nodes.add(value);
                    continue;
                }
                if (nvp.length == 2) {
                    String key = nvp[0].trim();
                    String value2 = nvp[1].trim();
                    if (key.equals("import")) {
                        if (!value2.startsWith(File.separator)) {
                            value2 = dirResources + value2;
                        }
                        if (nodeSet.imports.contains(value2)) {
                            this.duplicate(filePath, lineno, line);
                            continue;
                        }
                        this.get(dirResources, value2, nodeSet);
                        continue;
                    }
                    this.ignore(filePath, lineno, line, "expected import");
                    continue;
                }
                if (nvp.length == 3) {
                    value = nvp[1].trim() + "-" + nvp[0].trim();
                    if (nodeSet.nodes.contains(value)) {
                        this.duplicate(filePath, lineno, line);
                        continue;
                    }
                    nodeSet.nodes.add(value);
                    continue;
                }
                this.ignore(filePath, lineno, line, "too many items on line");
            }
            in.close();
        }
        catch (IOException e) {
            this.ignore(filePath, "file not found");
        }
        return nodeSet;
    }

    public ArrayList<String> get(String resourcesDir, String fileName) {
        NodeSet nodeSet = new NodeSet();
        this.get(resourcesDir, fileName, nodeSet);
        return nodeSet.nodes;
    }

    public ArrayList<String> get() {
        String dirResources = IDuccEnv.DUCC_RESOURCES_DIR;
        String fileName = "ducc.nodes";
        return this.get(dirResources, fileName);
    }

    public static void main(String[] args) {
        String dirResources = IDuccEnv.DUCC_RESOURCES_DIR;
        String fileName = "ducc.nodes";
        ArrayList<String> nodes = DuccNodes.getSysOutInstance().get(dirResources, fileName);
        for (String value : nodes) {
            System.out.println(value);
        }
    }

    private class NodeSet {
        public ArrayList<String> nodes = new ArrayList();
        public ArrayList<String> imports = new ArrayList();

        private NodeSet() {
        }
    }
}

