/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.helper;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;

public abstract class JmxHelper {
    private static DuccLogger logger = DuccLogger.getLogger(JmxHelper.class);
    private static DuccId jobid = null;
    private String jmxHost = "localhost";
    private int jmxPort = -1;
    private JMXServiceURL url = null;
    private JMXConnector jmxc = null;
    private MBeanServerConnection mbsc = null;

    protected void setJmxHost(String value) {
        this.jmxHost = value;
    }

    public String getJmxHost() {
        return this.jmxHost;
    }

    protected void setJmxPort(int value) {
        this.jmxPort = value;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public String getJmxUrl() {
        return "service:jmx:rmi:///jndi/rmi://" + this.getJmxHost() + ":" + this.getJmxPort() + "/jmxrmi";
    }

    public MBeanServerConnection getMBSC() {
        return this.mbsc;
    }

    protected void connect() throws Exception {
        String location = "connect";
        try {
            this.url = new JMXServiceURL(this.getJmxUrl());
            this.jmxc = JMXConnectorFactory.connect(this.url, null);
            this.mbsc = this.jmxc.getMBeanServerConnection();
            String id = this.jmxc.getConnectionId();
            logger.debug(location, jobid, new Object[]{id});
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
            throw e;
        }
    }

    protected void disconnect() throws Exception {
        String location = "disconnect";
        try {
            if (this.jmxc != null) {
                String id = this.jmxc.getConnectionId();
                this.jmxc.close();
                this.jmxc = null;
                logger.debug(location, jobid, new Object[]{id});
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
            throw e;
        }
    }

    protected String getJmxData() throws Exception {
        Object o = null;
        MBeanServerConnection mbsc = null;
        try {
            mbsc = this.getMBSC();
            o = mbsc.getAttribute(new ObjectName("java.lang:type=Runtime"), "Name");
        }
        catch (Exception e) {
            this.connect();
            mbsc = this.getMBSC();
            o = mbsc.getAttribute(new ObjectName("java.lang:type=Runtime"), "Name");
            this.disconnect();
        }
        String data = (String)o;
        return data;
    }

    public Long getPID() {
        String location = "getPID";
        Long retVal = new Long(0L);
        try {
            Long pid;
            String data = this.getJmxData();
            String[] address = data.split("@");
            retVal = pid = Long.valueOf(Long.parseLong(address[0]));
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }
}

