/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.jd.files.perf;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.jd.files.JobPerformanceSummary;
import org.apache.uima.ducc.common.jd.files.JobPerformanceSummaryData;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceMetricsSummaryItem;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceMetricsSummaryMap;
import org.apache.uima.ducc.common.jd.files.perf.PerformanceSummaryReader;

public class PerformanceSummaryWriter
extends PerformanceSummaryReader {
    @Deprecated
    private boolean legacy = false;

    public PerformanceSummaryWriter(String dirname) {
        super(dirname);
    }

    private void writeJsonGz() {
        try {
            ConcurrentSkipListMap<String, JobPerformanceSummary> map = new ConcurrentSkipListMap<String, JobPerformanceSummary>();
            Set<Map.Entry<String, PerformanceMetricsSummaryItem>> entries = this.summaryMap.entrySet();
            for (Map.Entry<String, PerformanceMetricsSummaryItem> entry : entries) {
                PerformanceMetricsSummaryItem item = entry.getValue();
                JobPerformanceSummary jps = new JobPerformanceSummary();
                jps.setAnalysisTime(item.getAnalysisTime());
                jps.setAnalysisTimeMax(item.getAnalysisTimeMax());
                jps.setAnalysisTimeMin(item.getAnalysisTimeMin());
                jps.setNumProcessed(item.getNumProcessed());
                jps.setName(item.getName());
                jps.setUniqueName(item.getUniqueName());
                map.put(jps.getUniqueName(), jps);
            }
            Integer casCount = this.summaryMap.casCount();
            JobPerformanceSummaryData data = new JobPerformanceSummaryData(map, casCount);
            this.jsonGz.exportData(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    private void writeSer(PerformanceMetricsSummaryMap map) {
        if (this.legacy) {
            try {
                FileOutputStream fos = new FileOutputStream(this.filename);
                ObjectOutputStream out = new ObjectOutputStream(fos);
                out.writeObject(map);
                out.close();
            }
            catch (Exception e) {
                System.err.println("PerformanceMetricsSummaryMap.writeSer() could not write file: " + this.filename);
            }
        }
    }

    public void writeSummary() {
        this.writeSer(this.summaryMap);
        try {
            this.writeJsonGz();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

