/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.factory;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.IDuccUser;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.container.FlagsHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.common.utils.id.DuccIdFactory;
import org.apache.uima.ducc.common.utils.id.IDuccId;
import org.apache.uima.ducc.common.utils.id.IDuccIdFactory;
import org.apache.uima.ducc.orchestrator.CGroupManager;
import org.apache.uima.ducc.orchestrator.OrUtil;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;
import org.apache.uima.ducc.orchestrator.exceptions.ResourceUnavailableForJobDriverException;
import org.apache.uima.ducc.orchestrator.factory.IJobFactory;
import org.apache.uima.ducc.orchestrator.factory.JobFactoryHelper;
import org.apache.uima.ducc.orchestrator.jd.scheduler.JdScheduler;
import org.apache.uima.ducc.transport.cmdline.ACommandLine;
import org.apache.uima.ducc.transport.cmdline.ICommandLine;
import org.apache.uima.ducc.transport.cmdline.JavaCommandLine;
import org.apache.uima.ducc.transport.cmdline.NonJavaCommandLine;
import org.apache.uima.ducc.transport.event.cli.JobRequestProperties;
import org.apache.uima.ducc.transport.event.cli.JobSpecificationProperties;
import org.apache.uima.ducc.transport.event.cli.ReservationSpecificationProperties;
import org.apache.uima.ducc.transport.event.cli.ServiceRequestProperties;
import org.apache.uima.ducc.transport.event.common.DuccProcess;
import org.apache.uima.ducc.transport.event.common.DuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.DuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.DuccUimaAggregate;
import org.apache.uima.ducc.transport.event.common.DuccUimaAggregateComponent;
import org.apache.uima.ducc.transport.event.common.DuccUimaDeploymentDescriptor;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.DuccWorkPopDriver;
import org.apache.uima.ducc.transport.event.common.IDuccCommand;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessType;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccUimaAggregate;
import org.apache.uima.ducc.transport.event.common.IDuccUimaAggregateComponent;
import org.apache.uima.ducc.transport.event.common.IDuccUimaDeployableConfiguration;
import org.apache.uima.ducc.transport.event.common.IDuccUimaDeploymentDescriptor;
import org.apache.uima.ducc.transport.event.common.IDuccUnits;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.IResourceState;
import org.apache.uima.ducc.user.common.QuotedOptions;

public class JobFactory
implements IJobFactory {
    private static JobFactory jobFactory = new JobFactory();
    private static final DuccLogger logger = DuccLogger.getLogger(JobFactory.class);
    private DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
    private OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    private JdScheduler jdScheduler = this.orchestratorCommonArea.getJdScheduler();
    private DuccIdFactory jdIdFactory = new DuccIdFactory();
    private String[] cps = null;

    public static IJobFactory getInstance() {
        return jobFactory;
    }

    private JobFactory() {
    }

    private int addEnvironment(DuccWorkJob job, String type, ACommandLine aCommandLine, String environmentVariables) {
        String methodName = "addEnvironment";
        logger.trace(methodName, job.getDuccId(), new Object[]{"enter"});
        int retVal = 0;
        if (environmentVariables != null) {
            Map envMap;
            logger.debug(methodName, job.getDuccId(), new Object[]{environmentVariables});
            ArrayList envVarList = QuotedOptions.tokenizeList((String)environmentVariables, (boolean)true);
            try {
                envMap = QuotedOptions.parseAssignments((List)envVarList, (int)0);
            }
            catch (IllegalArgumentException e) {
                logger.warn(methodName, job.getDuccId(), new Object[]{"Invalid environment syntax in: " + environmentVariables});
                return 0;
            }
            aCommandLine.addEnvironment(envMap);
            retVal = envMap.size();
            IDuccStandardInfo stdInfo = job.getStandardInfo();
            if (stdInfo != null) {
                stdInfo.setUmask((String)envMap.get("DUCC_UMASK"));
            }
        }
        logger.trace(methodName, job.getDuccId(), new Object[]{"exit"});
        return retVal;
    }

    private ArrayList<String> toArrayList(String overrides) {
        String methodName = "toArrayList";
        logger.trace(methodName, null, new Object[]{"enter"});
        ArrayList list = QuotedOptions.tokenizeList((String)overrides, (boolean)true);
        logger.trace(methodName, null, new Object[]{"exit"});
        return list;
    }

    private void dump(DuccWorkJob job, IDuccUimaAggregate uimaAggregate) {
        String methodName = "dump";
        logger.info(methodName, job.getDuccId(), new Object[]{"brokerURL     " + uimaAggregate.getBrokerURL()});
        logger.info(methodName, job.getDuccId(), new Object[]{"endpoint      " + uimaAggregate.getEndpoint()});
        logger.info(methodName, job.getDuccId(), new Object[]{"description   " + uimaAggregate.getDescription()});
        logger.info(methodName, job.getDuccId(), new Object[]{"name          " + uimaAggregate.getName()});
        logger.info(methodName, job.getDuccId(), new Object[]{"thread-count  " + uimaAggregate.getThreadCount()});
        List components = uimaAggregate.getComponents();
        for (IDuccUimaAggregateComponent component : components) {
            logger.info(methodName, job.getDuccId(), new Object[]{"descriptor    " + component.getDescriptor()});
            List overrides = component.getOverrides();
            for (String override : overrides) {
                logger.info(methodName, job.getDuccId(), new Object[]{"override      " + override});
            }
        }
    }

    private void dump(DuccWorkJob job, IDuccUimaDeploymentDescriptor uimaDeploymentDescriptor) {
        String methodName = "dump";
        logger.info(methodName, job.getDuccId(), new Object[]{"uimaDeploymentDescriptor      " + uimaDeploymentDescriptor});
    }

    private void logSweeper(String logDir, DuccId jobId) {
        String methodName = "logSweeper";
        if (logDir != null) {
            if (jobId != null) {
                if (!logDir.endsWith(File.separator)) {
                    logDir = logDir + File.separator;
                }
                logDir = logDir + jobId;
                try {
                    File file = new File(logDir);
                    if (file.exists()) {
                        File dest = new File(logDir + ".sweep." + Calendar.getInstance().getTime().toString());
                        file.renameTo(dest);
                        logger.warn(methodName, jobId, new Object[]{"renamed " + logDir});
                    }
                }
                catch (Throwable t) {
                    logger.warn(methodName, jobId, new Object[]{"unable to rename " + logDir, t});
                }
            } else {
                logger.warn(methodName, jobId, new Object[]{"jobId is null"});
            }
        } else {
            logger.warn(methodName, jobId, new Object[]{"logDir is null"});
        }
    }

    private boolean isJpUima(IDuccTypes.DuccType duccType, IDuccWorkService.ServiceDeploymentType serviceDeploymentType) {
        boolean retVal = true;
        block0 : switch (duccType) {
            case Job: {
                break;
            }
            case Service: {
                switch (serviceDeploymentType) {
                    case uima: {
                        break block0;
                    }
                }
                retVal = false;
                break;
            }
            default: {
                retVal = false;
            }
        }
        return retVal;
    }

    private void setDebugPorts(JobRequestProperties jobRequestProperties, DuccWorkJob job) {
        String portProcess;
        String location = "setDebugPorts";
        DuccId jobid = job.getDuccId();
        String portDriver = jobRequestProperties.getProperty(JobSpecificationProperties.key_driver_debug);
        if (portDriver != null) {
            try {
                long port = Long.parseLong(portDriver);
                job.setDebugPortDriver(port);
                logger.debug(location, jobid, new Object[]{"Driver debug port: " + job.getDebugPortDriver()});
            }
            catch (Exception e) {
                logger.error(location, jobid, new Object[]{"Invalid driver debug port: " + portDriver});
            }
        }
        if ((portProcess = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_debug)) != null) {
            try {
                long port = Long.parseLong(portProcess);
                job.setDebugPortProcess(port);
                logger.debug(location, jobid, new Object[]{"Process debug port: " + job.getDebugPortProcess()});
            }
            catch (Exception e) {
                logger.error(location, jobid, new Object[]{"Invalid process debug port: " + portProcess});
            }
        }
    }

    private String getPrependUserCP(DuccId jobid, JobRequestProperties jobSpec) {
        String envKey = IDuccUser.EnvironmentVariable.DUCC_USER_CP_PREPEND.value();
        String prependDefault = IDuccEnv.DUCC_HOME + File.separator + "lib" + File.separator + "uima-ducc" + File.separator + "user" + File.separator + "*";
        String retVal = JobFactoryHelper.getEnvVal(jobid, jobSpec, envKey, prependDefault);
        return retVal;
    }

    private String addUimaDucc(String prependCP, String cp) {
        StringBuffer sb = new StringBuffer();
        sb.append(prependCP);
        sb.append(File.pathSeparator);
        if (cp != null) {
            String tcp = cp.trim();
            sb.append(tcp);
        }
        return sb.toString();
    }

    private JavaCommandLine buildJobDriverCommandLine(JobRequestProperties jobRequestProperties, DuccId jobid) {
        String crcfg;
        JavaCommandLine jcl = null;
        String javaCmd = jobRequestProperties.getProperty(JobSpecificationProperties.key_jvm);
        jcl = new JavaCommandLine(javaCmd);
        jcl.setClassName("org.apache.uima.ducc.common.main.DuccService");
        jcl.addOption(IDuccCommand.arg_ducc_deploy_configruation);
        jcl.addOption("-Dducc.deploy.components=jd");
        jcl.addOption("-Dducc.job.id=" + jobid.toString());
        jcl.setClasspath(this.getDuccClasspath(0));
        boolean haveXmx = false;
        String driver_jvm_args = jobRequestProperties.getProperty(JobSpecificationProperties.key_driver_jvm_args);
        ArrayList dTokens = QuotedOptions.tokenizeList((String)driver_jvm_args, (boolean)true);
        for (Object token : dTokens) {
            jcl.addOption((String)token);
            if (haveXmx) continue;
            haveXmx = ((String)token).startsWith("-Xmx");
        }
        String siteJvmArgs = DuccPropertiesResolver.getInstance().getFileProperty("ducc.driver.jvm.args");
        dTokens = QuotedOptions.tokenizeList((String)siteJvmArgs, (boolean)true);
        for (String token : dTokens) {
            if (haveXmx && token.startsWith("-Xmx")) continue;
            jcl.addOption(token);
        }
        String opt = FlagsHelper.Name.JobId.dname() + "=" + jobid.getFriendly();
        jcl.addOption(opt);
        String crxml = jobRequestProperties.getProperty(JobSpecificationProperties.key_driver_descriptor_CR);
        if (crxml != null) {
            opt = FlagsHelper.Name.CollectionReaderXml.dname() + "=" + crxml;
            jcl.addOption(opt);
        }
        if ((crcfg = jobRequestProperties.getProperty(JobSpecificationProperties.key_driver_descriptor_CR_overrides)) != null) {
            opt = FlagsHelper.Name.CollectionReaderCfg.dname() + "=" + crcfg;
            jcl.addOption(opt);
        }
        String prependUserCP = this.getPrependUserCP(jobid, jobRequestProperties);
        String userCP = jobRequestProperties.getProperty(JobSpecificationProperties.key_classpath);
        userCP = this.addUimaDucc(prependUserCP, userCP);
        opt = FlagsHelper.Name.UserClasspath.dname() + "=" + userCP;
        jcl.addOption(opt);
        String wiTimeout = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_per_item_time_max);
        if (wiTimeout == null) {
            DuccPropertiesResolver duccPropertiesResolver = DuccPropertiesResolver.getInstance();
            wiTimeout = duccPropertiesResolver.getFileProperty("ducc.default.process.per.item.time.max");
        }
        this.addDashD(jcl, FlagsHelper.Name.WorkItemTimeout, wiTimeout);
        this.addDashD(jcl, FlagsHelper.Name.JobDirectory, jobRequestProperties.getProperty(JobSpecificationProperties.key_log_directory));
        String keyFCRS = "ducc.flow-controller.specifier";
        String valueFCRS = DuccPropertiesResolver.getInstance().getFileProperty(keyFCRS);
        this.addDashD(jcl, FlagsHelper.Name.JpFlowController, valueFCRS);
        this.addDashD(jcl, FlagsHelper.Name.JpAeDescriptor, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_AE));
        this.addDashD(jcl, FlagsHelper.Name.JpAeOverrides, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_AE_overrides));
        this.addDashD(jcl, FlagsHelper.Name.JpCcDescriptor, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_CC));
        this.addDashD(jcl, FlagsHelper.Name.JpCcOverrides, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_CC_overrides));
        this.addDashD(jcl, FlagsHelper.Name.JpCmDescriptor, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_CM));
        this.addDashD(jcl, FlagsHelper.Name.JpCmOverrides, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_CM_overrides));
        this.addDashD(jcl, FlagsHelper.Name.JpDd, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_DD));
        this.addDashD(jcl, FlagsHelper.Name.JpThreadCount, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_pipeline_count));
        FlagsHelper.Name flagName = FlagsHelper.Name.UserErrorHandlerClassname;
        String flagValue = jobRequestProperties.getProperty(JobSpecificationProperties.key_driver_exception_handler);
        this.addDashD(jcl, flagName, flagValue);
        flagName = FlagsHelper.Name.UserErrorHandlerCfg;
        flagValue = jobRequestProperties.getProperty(JobSpecificationProperties.key_driver_exception_handler_arguments);
        this.addDashD(jcl, flagName, flagValue);
        jcl.setLogDirectory(jobRequestProperties.getProperty(JobSpecificationProperties.key_log_directory));
        return jcl;
    }

    private void addDashD(JavaCommandLine jcl, String flagName, String flagValue) {
        String optValue;
        String optName;
        String location = "addDashD";
        logger.info(location, null, new Object[]{flagName + "=" + flagValue});
        if (jcl != null && flagName != null && (optName = flagName.trim()).length() > 0 && flagValue != null && (optValue = flagValue.trim()).length() > 0) {
            String opt = optName + "=" + optValue;
            jcl.addOption(opt);
        }
    }

    private void addDashD(JavaCommandLine jcl, FlagsHelper.Name name, String flagValue) {
        String flagName = null;
        if (name != null) {
            flagName = name.dname();
        }
        this.addDashD(jcl, flagName, flagValue);
    }

    private void createDriver(JobRequestProperties jobRequestProperties, DuccWorkJob job) throws ResourceUnavailableForJobDriverException {
        String methodName = "createDriver";
        String brokerUrl = this.dpr.getProperty("ducc.broker.url");
        job.setJobBroker(brokerUrl);
        String jdQueuePrefix = this.dpr.getProperty("ducc.jd.queue.prefix");
        job.setJobQueue(jdQueuePrefix + job.getDuccId());
        JavaCommandLine driverCommandLine = this.buildJobDriverCommandLine(jobRequestProperties, job.getDuccId());
        String driverEnvironmentVariables = jobRequestProperties.getProperty(JobSpecificationProperties.key_environment);
        int envCountDriver = this.addEnvironment(job, "driver", (ACommandLine)driverCommandLine, driverEnvironmentVariables);
        logger.info(methodName, job.getDuccId(), new Object[]{"driver env vars: " + envCountDriver});
        logger.debug(methodName, job.getDuccId(), new Object[]{"driver: " + driverCommandLine.getCommand()});
        DuccWorkPopDriver driver = new DuccWorkPopDriver();
        driver.setCommandLine((ICommandLine)driverCommandLine);
        DuccId processIdentity = this.jdIdFactory.next();
        int friendlyId = driver.getProcessMap().size();
        processIdentity.setFriendly((long)friendlyId);
        DuccId jobIdentity = job.getDuccId();
        NodeIdentity nodeIdentity = this.jdScheduler.allocate(jobIdentity, processIdentity);
        if (nodeIdentity == null) {
            throw new ResourceUnavailableForJobDriverException();
        }
        DuccProcess driverProcess = new DuccProcess(processIdentity, nodeIdentity, IDuccProcessType.ProcessType.Pop);
        long driver_max_size_in_bytes = JobFactoryHelper.getByteSizeJobDriver();
        CGroupManager.assign((IDuccId)job.getDuccId(), (IDuccProcess)driverProcess, driver_max_size_in_bytes);
        OrUtil.setResourceState((IDuccWorkJob)job, (IDuccProcess)driverProcess, IResourceState.ResourceState.Allocated);
        driverProcess.setNodeIdentity(nodeIdentity);
        driver.getProcessMap().put((Object)driverProcess.getDuccId(), (Object)driverProcess);
        this.orchestratorCommonArea.getProcessAccounting().addProcess(processIdentity, jobIdentity);
        job.setDriver(driver);
    }

    private void checkSchedulingLimits(DuccWorkJob job, DuccSchedulingInfo schedulingInfo) {
        String methodName = "check_max_job_pipelines";
        long ducc_limit = 0L;
        String p_limit = DuccPropertiesResolver.get((String)"ducc.threads.limit");
        if (p_limit == null) {
            p_limit = DuccPropertiesResolver.get((String)"ducc.job.max.pipelines.count");
        }
        if (p_limit != null && !p_limit.equals("unlimited")) {
            try {
                ducc_limit = Long.parseLong(p_limit);
            }
            catch (Exception e) {
                logger.error(methodName, job.getDuccId(), (Throwable)e, new Object[0]);
            }
        }
        if (ducc_limit <= 0L) {
            return;
        }
        int pipelines_per_process = schedulingInfo.getIntThreadsPerProcess();
        if ((long)pipelines_per_process > ducc_limit) {
            schedulingInfo.setIntThreadsPerProcess((int)ducc_limit);
        }
        long processes_limit = ducc_limit / (long)schedulingInfo.getIntThreadsPerProcess();
        long user_limit = schedulingInfo.getLongProcessesMax();
        logger.trace(methodName, job.getDuccId(), new Object[]{"user_limit=" + user_limit + " ducc_processes_limit=" + processes_limit});
        if (user_limit > processes_limit) {
            logger.info(methodName, job.getDuccId(), new Object[]{"change max job processes from " + user_limit + " to " + ducc_limit + "/" + schedulingInfo.getIntThreadsPerProcess()});
            schedulingInfo.setLongProcessesMax(processes_limit);
        }
    }

    public DuccWorkJob createJob(JobRequestProperties jobRequestProperties) throws ResourceUnavailableForJobDriverException {
        IDuccIdFactory duccIdFactory = this.orchestratorCommonArea.getDuccIdFactory();
        DuccWorkJob job = new DuccWorkJob();
        job.setDuccType(IDuccTypes.DuccType.Job);
        job.setDuccId(duccIdFactory.next());
        this.createDriver(jobRequestProperties, job);
        this.setDebugPorts(jobRequestProperties, job);
        return this.create(jobRequestProperties, job);
    }

    public DuccWorkJob createService(JobRequestProperties jobRequestProperties) {
        IDuccIdFactory duccIdFactory = this.orchestratorCommonArea.getDuccIdFactory();
        DuccWorkJob job = new DuccWorkJob();
        job.setDuccType(IDuccTypes.DuccType.Service);
        job.setDuccId(duccIdFactory.next());
        return this.create(jobRequestProperties, job);
    }

    private DuccWorkJob create(JobRequestProperties jobRequestProperties, DuccWorkJob job) {
        String pi_time;
        String methodName = "create";
        jobRequestProperties.normalize();
        DuccId jobid = job.getDuccId();
        IDuccTypes.DuccType duccType = job.getDuccType();
        if (jobRequestProperties.containsKey((Object)ServiceRequestProperties.key_service_type_custom)) {
            job.setServiceDeploymentType(IDuccWorkService.ServiceDeploymentType.custom);
        } else if (jobRequestProperties.containsKey((Object)ServiceRequestProperties.key_service_type_other)) {
            job.setServiceDeploymentType(IDuccWorkService.ServiceDeploymentType.other);
        } else if (jobRequestProperties.containsKey((Object)ServiceRequestProperties.key_service_type_uima)) {
            job.setServiceDeploymentType(IDuccWorkService.ServiceDeploymentType.uima);
        } else {
            job.setServiceDeploymentType(IDuccWorkService.ServiceDeploymentType.unspecified);
        }
        String serviceId = null;
        if (jobRequestProperties.containsKey((Object)ServiceRequestProperties.key_service_id)) {
            serviceId = jobRequestProperties.getProperty(ServiceRequestProperties.key_service_id);
        }
        job.setServiceId(serviceId);
        this.logSweeper(jobRequestProperties.getProperty(JobRequestProperties.key_log_directory), job.getDuccId());
        jobRequestProperties.specification(logger, job.getDuccId());
        String javaCmd = jobRequestProperties.getProperty(JobSpecificationProperties.key_jvm);
        if (javaCmd == null) {
            // empty if block
        }
        DuccStandardInfo standardInfo = new DuccStandardInfo();
        job.setStandardInfo((IDuccStandardInfo)standardInfo);
        standardInfo.setUser(jobRequestProperties.getProperty(JobSpecificationProperties.key_user));
        standardInfo.setSubmitter(jobRequestProperties.getProperty(JobSpecificationProperties.key_submitter_pid_at_host));
        standardInfo.setDateOfSubmission(TimeStamp.getCurrentMillis());
        standardInfo.setDateOfCompletion(null);
        standardInfo.setDescription(jobRequestProperties.getProperty(JobSpecificationProperties.key_description));
        standardInfo.setLogDirectory(jobRequestProperties.getProperty(JobSpecificationProperties.key_log_directory));
        standardInfo.setWorkingDirectory(jobRequestProperties.getProperty(JobSpecificationProperties.key_working_directory));
        String notifications = jobRequestProperties.getProperty(JobSpecificationProperties.key_notifications);
        if (notifications == null) {
            standardInfo.setNotifications(null);
        } else {
            String[] notificationsArray = notifications.split(" ,");
            for (int i = 0; i < notificationsArray.length; ++i) {
                notificationsArray[i] = notificationsArray[i].trim();
            }
            standardInfo.setNotifications(notificationsArray);
        }
        DuccSchedulingInfo schedulingInfo = new DuccSchedulingInfo();
        job.setSchedulingInfo((IDuccSchedulingInfo)schedulingInfo);
        String memory_process_size = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_memory_size);
        long jpGB = JobFactoryHelper.getByteSizeJobProcess(memory_process_size) / JobFactoryHelper.GB;
        if (jpGB > 0L) {
            schedulingInfo.setMemorySizeRequested("" + jpGB);
        }
        schedulingInfo.setSchedulingClass(jobRequestProperties.getProperty(JobSpecificationProperties.key_scheduling_class));
        schedulingInfo.setSchedulingPriority(jobRequestProperties.getProperty(JobSpecificationProperties.key_scheduling_priority));
        schedulingInfo.setProcessesMax(jobRequestProperties.getProperty(JobSpecificationProperties.key_process_deployments_max));
        schedulingInfo.setProcessesMin(jobRequestProperties.getProperty(JobSpecificationProperties.key_process_deployments_min));
        schedulingInfo.setThreadsPerProcess(jobRequestProperties.getProperty(JobSpecificationProperties.key_process_pipeline_count));
        schedulingInfo.setMemorySizeRequested(jobRequestProperties.getProperty(JobSpecificationProperties.key_process_memory_size));
        schedulingInfo.setMemoryUnits(IDuccUnits.MemoryUnits.GB);
        if (job.getDuccType() == IDuccTypes.DuccType.Job) {
            this.checkSchedulingLimits(job, schedulingInfo);
        }
        if ((pi_time = jobRequestProperties.getProperty(JobRequestProperties.key_process_initialization_time_max)) == null) {
            pi_time = DuccPropertiesResolver.get((String)"ducc.default.process.init.time.max");
        }
        try {
            long value = Long.parseLong(pi_time) * 60L * 1000L;
            standardInfo.setProcessInitializationTimeMax(value);
        }
        catch (Exception e) {
            logger.error(methodName, job.getDuccId(), (Throwable)e, new Object[0]);
        }
        JavaCommandLine pipelineCommandLine = new JavaCommandLine(javaCmd);
        pipelineCommandLine.setClassName("main:provided-by-Process-Manager");
        IDuccWorkService.ServiceDeploymentType serviceDeploymentType = job.getServiceDeploymentType();
        switch (duccType) {
            case Service: {
                String name = JobSpecificationProperties.key_process_DD;
                String arg = jobRequestProperties.getProperty(name);
                logger.debug(methodName, job.getDuccId(), new Object[]{name + ": " + arg});
                pipelineCommandLine.addArgument(arg);
                break;
            }
        }
        if (this.isJpUima(duccType, serviceDeploymentType)) {
            String process_thread_count;
            String process_error_window;
            String process_DD = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_DD);
            if (process_DD != null) {
                DuccUimaDeploymentDescriptor uimaDeploymentDescriptor = new DuccUimaDeploymentDescriptor(process_DD);
                job.setUimaDeployableConfiguration((IDuccUimaDeployableConfiguration)uimaDeploymentDescriptor);
                this.dump(job, (IDuccUimaDeploymentDescriptor)uimaDeploymentDescriptor);
            } else {
                String CCDescriptor;
                String AEDescriptor;
                String jdQueuePrefix = this.dpr.getProperty("ducc.jd.queue.prefix");
                String name = jdQueuePrefix + job.getDuccId().toString();
                String description = job.getStandardInfo().getDescription();
                int threadCount = Integer.parseInt(job.getSchedulingInfo().getThreadsPerProcess());
                String brokerURL = job.getjobBroker();
                String endpoint = job.getjobQueue();
                ArrayList<DuccUimaAggregateComponent> components = new ArrayList<DuccUimaAggregateComponent>();
                String CMDescriptor = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_CM);
                if (CMDescriptor != null) {
                    ArrayList<String> CMOverrides = this.toArrayList(jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_CM_overrides));
                    DuccUimaAggregateComponent componentCM = new DuccUimaAggregateComponent(CMDescriptor, CMOverrides);
                    components.add(componentCM);
                }
                if ((AEDescriptor = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_AE)) != null) {
                    ArrayList<String> AEOverrides = this.toArrayList(jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_AE_overrides));
                    DuccUimaAggregateComponent componentAE = new DuccUimaAggregateComponent(AEDescriptor, AEOverrides);
                    components.add(componentAE);
                }
                if ((CCDescriptor = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_CC)) != null) {
                    ArrayList<String> CCOverrides = this.toArrayList(jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_CC_overrides));
                    DuccUimaAggregateComponent componentCC = new DuccUimaAggregateComponent(CCDescriptor, CCOverrides);
                    components.add(componentCC);
                }
                DuccUimaAggregate uimaAggregate = new DuccUimaAggregate(name, description, threadCount, brokerURL, endpoint, components);
                job.setUimaDeployableConfiguration((IDuccUimaDeployableConfiguration)uimaAggregate);
                this.dump(job, (IDuccUimaAggregate)uimaAggregate);
            }
            String prependUserCP = this.getPrependUserCP(jobid, jobRequestProperties);
            String userCP = jobRequestProperties.getProperty(JobSpecificationProperties.key_classpath);
            userCP = this.addUimaDucc(prependUserCP, userCP);
            pipelineCommandLine.setClasspath(userCP);
            String process_jvm_args = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_jvm_args);
            ArrayList pTokens = QuotedOptions.tokenizeList((String)process_jvm_args, (boolean)true);
            for (Object token : pTokens) {
                pipelineCommandLine.addOption((String)token);
            }
            String siteJvmArgs = DuccPropertiesResolver.getInstance().getFileProperty("ducc.process.jvm.args");
            pTokens = QuotedOptions.tokenizeList((String)siteJvmArgs, (boolean)true);
            for (String token : pTokens) {
                pipelineCommandLine.addOption(token);
            }
            String duccCP = this.getDuccClasspath(1);
            String opt = FlagsHelper.Name.DuccClasspath.dname() + "=" + duccCP;
            logger.debug(methodName, job.getDuccId(), new Object[]{"opt pipeline: " + opt});
            pipelineCommandLine.addOption(opt);
            if (process_DD != null) {
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpType, "uima-as");
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpDd, process_DD);
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JobDirectory, jobRequestProperties.getProperty(JobSpecificationProperties.key_log_directory));
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpThreadCount, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_pipeline_count));
            } else {
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpType, "uima");
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpAeDescriptor, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_AE));
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpAeOverrides, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_AE_overrides));
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpCcDescriptor, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_CC));
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpCcOverrides, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_CC_overrides));
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpCmDescriptor, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_CM));
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpCmOverrides, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_descriptor_CM_overrides));
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JobDirectory, jobRequestProperties.getProperty(JobSpecificationProperties.key_log_directory));
                String keyFCRS = "ducc.flow-controller.specifier";
                String valueFCRS = DuccPropertiesResolver.getInstance().getFileProperty(keyFCRS);
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpFlowController, valueFCRS);
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpThreadCount, jobRequestProperties.getProperty(JobSpecificationProperties.key_process_pipeline_count));
            }
            String process_error_threshold = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_error_threshold);
            if (process_error_threshold != null) {
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpErrorThreshold, process_error_threshold);
            }
            if ((process_error_window = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_error_window)) != null) {
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpErrorWindowSize, process_error_window);
            }
            if ((process_thread_count = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_pipeline_count)) != null) {
                this.addDashD(pipelineCommandLine, FlagsHelper.Name.JpThreadCount, process_thread_count);
            }
            String processEnvironmentVariables = jobRequestProperties.getProperty(JobSpecificationProperties.key_environment);
            int envCountProcess = this.addEnvironment(job, "process", (ACommandLine)pipelineCommandLine, processEnvironmentVariables);
            logger.info(methodName, job.getDuccId(), new Object[]{"process env vars: " + envCountProcess});
            logger.debug(methodName, job.getDuccId(), new Object[]{"pipeline: " + pipelineCommandLine.getCommand()});
            pipelineCommandLine.setLogDirectory(jobRequestProperties.getProperty(JobSpecificationProperties.key_log_directory));
            job.setCommandLine((ICommandLine)pipelineCommandLine);
        } else {
            String process_executable = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_executable);
            NonJavaCommandLine executableProcessCommandLine = new NonJavaCommandLine(process_executable);
            String processEnvironmentVariables = jobRequestProperties.getProperty(JobSpecificationProperties.key_environment);
            int envCountProcess = this.addEnvironment(job, "process", (ACommandLine)executableProcessCommandLine, processEnvironmentVariables);
            logger.info(methodName, job.getDuccId(), new Object[]{"process env vars: " + envCountProcess});
            logger.debug(methodName, job.getDuccId(), new Object[]{"ducclet: " + executableProcessCommandLine.getCommandLineString()});
            job.setCommandLine((ICommandLine)executableProcessCommandLine);
            ArrayList process_executable_arguments = QuotedOptions.tokenizeList((String)jobRequestProperties.getProperty(JobSpecificationProperties.key_process_executable_args), (boolean)true);
            executableProcessCommandLine.getArguments().addAll(process_executable_arguments);
        }
        String failures_cap = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_initialization_failures_cap);
        try {
            long process_failures_cap = Long.parseLong(failures_cap);
            if (process_failures_cap > 0L) {
                job.setProcessInitFailureCap(process_failures_cap);
            } else {
                logger.warn(methodName, job.getDuccId(), new Object[]{"invalid " + JobSpecificationProperties.key_process_initialization_failures_cap + ": " + failures_cap});
            }
        }
        catch (Exception e) {
            logger.warn(methodName, job.getDuccId(), new Object[]{"invalid " + JobSpecificationProperties.key_process_initialization_failures_cap + ": " + failures_cap});
        }
        String failures_limit = jobRequestProperties.getProperty(JobSpecificationProperties.key_process_failures_limit);
        try {
            long process_failures_limit = Long.parseLong(failures_limit);
            if (process_failures_limit > 0L) {
                job.setProcessFailureLimit(process_failures_limit);
            } else {
                logger.warn(methodName, job.getDuccId(), new Object[]{"invalid " + JobSpecificationProperties.key_process_failures_limit + ": " + failures_limit});
            }
        }
        catch (Exception e) {
            logger.warn(methodName, job.getDuccId(), new Object[]{"invalid " + JobSpecificationProperties.key_process_failures_limit + ": " + failures_limit});
        }
        String depstr = jobRequestProperties.getProperty(JobSpecificationProperties.key_service_dependency);
        if (depstr == null) {
            logger.debug(methodName, job.getDuccId(), new Object[]{"No service dependencies"});
        } else {
            logger.debug(methodName, job.getDuccId(), new Object[]{"Adding service dependency", depstr});
            String[] deps = depstr.split("\\s+");
            job.setServiceDependencies(deps);
        }
        String ep = jobRequestProperties.getProperty(ServiceRequestProperties.key_service_request_endpoint);
        if (ep == null) {
            logger.debug(methodName, job.getDuccId(), new Object[]{"No service endpoint"});
        } else {
            logger.debug(methodName, job.getDuccId(), new Object[]{"Adding service endpoint", ep});
            job.setServiceEndpoint(ep);
        }
        if (jobRequestProperties.containsKey((Object)JobSpecificationProperties.key_cancel_on_interrupt)) {
            job.setCancelOnInterrupt();
        } else if (jobRequestProperties.containsKey((Object)ReservationSpecificationProperties.key_cancel_managed_reservation_on_interrupt)) {
            job.setCancelOnInterrupt();
        }
        return job;
    }

    private String getDuccClasspath(int type) {
        if (this.cps != null) {
            return this.cps[type];
        }
        DuccProperties props = new DuccProperties();
        try {
            props.load(IDuccEnv.DUCC_CLASSPATH_FILE);
        }
        catch (Exception e) {
            logger.error("getClasspath", null, new Object[]{"Using full classpath as failed to load " + IDuccEnv.DUCC_CLASSPATH_FILE});
            return System.getProperty("java.class.path");
        }
        if (props.getProperty("ducc.reload.file") != null) {
            return props.getProperty(type == 0 ? "ducc.jobdriver.classpath" : "ducc.jobprocess.classpath");
        }
        this.cps = new String[2];
        this.cps[0] = props.getProperty("ducc.jobdriver.classpath");
        this.cps[1] = props.getProperty("ducc.jobprocess.classpath");
        return this.cps[type];
    }
}

