/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.maintenance;

import java.util.Collection;
import java.util.Set;
import org.apache.uima.ducc.common.internationalization.Messages;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.OrUtil;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;
import org.apache.uima.ducc.orchestrator.OrchestratorHelper;
import org.apache.uima.ducc.orchestrator.StateManager;
import org.apache.uima.ducc.orchestrator.WorkMapHelper;
import org.apache.uima.ducc.orchestrator.ckpt.OrchestratorCheckpoint;
import org.apache.uima.ducc.orchestrator.maintenance.NodeAccounting;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.DuccWorkPopDriver;
import org.apache.uima.ducc.transport.event.common.IDuccCompletionType;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IProcessState;
import org.apache.uima.ducc.transport.event.common.IRationale;
import org.apache.uima.ducc.transport.event.common.IResourceState;
import org.apache.uima.ducc.transport.event.common.Rationale;

public class HealthMonitor {
    private static final DuccLogger logger = DuccLogger.getLogger(HealthMonitor.class);
    private static HealthMonitor healthMonitor = new HealthMonitor();
    private OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    private Messages messages = this.orchestratorCommonArea.getSystemMessages();

    public static HealthMonitor getInstance() {
        return healthMonitor;
    }

    private boolean isCancelJobExcessiveInitializationFailures(IDuccWorkJob job) {
        long limit;
        long count;
        String methodName = "isCancelJobExcessiveInitializationFailures";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        boolean ckpt = false;
        if (!job.isInitialized() && (count = job.getProcessInitFailureCount()) >= (limit = job.getProcessInitFailureLimit())) {
            Rationale rationale = new Rationale("health monitor detected job initialization failures limit reached:" + limit);
            StateManager.getInstance().jobTerminate(job, IDuccCompletionType.JobCompletionType.ProcessInitializationFailure, (IRationale)rationale, IResourceState.ProcessDeallocationType.JobCanceled);
            logger.info(methodName, job.getDuccId(), new Object[]{IDuccCompletionType.JobCompletionType.ProcessInitializationFailure});
            ckpt = true;
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return ckpt;
    }

    private boolean isCancelJobCappedWithNoJobProcesses(IDuccWorkJob job) {
        String methodName = "isCancelJobCappedWithNoJobProcesses";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        boolean ckpt = false;
        long count = job.getProcessInitFailureCount();
        long cap = job.getProcessInitFailureCap();
        long procs = job.getAliveProcessCount();
        logger.debug(methodName, null, new Object[]{"fail.count:" + count + " fail.cap:" + cap + " alive.procs:" + procs});
        if (count >= cap && job.getAliveProcessCount() == 0L) {
            Rationale rationale = new Rationale("health monitor detected no resources assigned and job initialization failures cap reached:" + cap);
            StateManager.getInstance().jobTerminate(job, IDuccCompletionType.JobCompletionType.ProcessInitializationFailure, (IRationale)rationale, IResourceState.ProcessDeallocationType.JobCanceled);
            logger.info(methodName, job.getDuccId(), new Object[]{IDuccCompletionType.JobCompletionType.ProcessInitializationFailure});
            ckpt = true;
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return ckpt;
    }

    private boolean isCancelJobExcessiveProcessFailures(IDuccWorkJob job) {
        String methodName = "isCancelJobExcessiveProcessFailures";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        boolean ckpt = false;
        long processFailureCount = job.getProcessFailureCount();
        if (processFailureCount > 0L) {
            long limit = job.getProcessFailureLimit();
            if (job.isInitialized()) {
                if (processFailureCount >= limit) {
                    Rationale rationale = new Rationale("health monitor detected job process failures limit reached:" + limit);
                    StateManager.getInstance().jobTerminate(job, IDuccCompletionType.JobCompletionType.ProcessFailure, (IRationale)rationale, IResourceState.ProcessDeallocationType.JobCanceled);
                    logger.info(methodName, job.getDuccId(), new Object[]{IDuccCompletionType.JobCompletionType.ProcessFailure});
                    ckpt = true;
                }
            } else {
                Rationale rationale = new Rationale("health monitor detected job process failure during initialization of first process");
                StateManager.getInstance().jobTerminate(job, IDuccCompletionType.JobCompletionType.ProcessInitializationFailure, (IRationale)rationale, IResourceState.ProcessDeallocationType.JobCanceled);
                logger.info(methodName, job.getDuccId(), new Object[]{IDuccCompletionType.JobCompletionType.ProcessInitializationFailure});
                ckpt = true;
            }
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return ckpt;
    }

    private boolean isCancelJobDriverProcessFailed(IDuccWorkJob job) {
        String methodName = "isCancelJobDriverProcessFailed";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        boolean ckpt = false;
        if (!job.isFinished()) {
            DuccWorkPopDriver driver = job.getDriver();
            IDuccProcessMap processMap = driver.getProcessMap();
            if (processMap != null) {
                Collection processCollection = processMap.values();
                for (IDuccProcess process : processCollection) {
                    if (!process.isComplete()) continue;
                    Rationale rationale = new Rationale("health monitor detected job driver failed unexpectedly");
                    StateManager.getInstance().jobTerminate(job, IDuccCompletionType.JobCompletionType.DriverProcessFailed, (IRationale)rationale, IResourceState.ProcessDeallocationType.JobCanceled);
                    logger.info(methodName, job.getDuccId(), new Object[]{IDuccCompletionType.JobCompletionType.DriverProcessFailed});
                    ckpt = true;
                    break;
                }
            }
            if (job.getProcessMap().getAliveProcessCount() == 0) {
                job.getSchedulingInfo().setWorkItemsDispatched("0");
            }
        } else if (!job.getSchedulingInfo().getWorkItemsDispatched().equals("0")) {
            job.getSchedulingInfo().setWorkItemsDispatched("0");
            logger.info(methodName, job.getDuccId(), new Object[]{"dispatched set to 0"});
            ckpt = true;
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return ckpt;
    }

    private boolean isDriverCompleted(IDuccWorkJob job) {
        DuccWorkPopDriver driver;
        IDuccProcessMap processMap;
        String methodName = "isDriverCompleted";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        boolean ckpt = false;
        if (job.isFinished() && !job.hasAliveProcess() && (processMap = (driver = job.getDriver()).getProcessMap()) != null) {
            Collection processCollection = processMap.values();
            for (IDuccProcess process : processCollection) {
                if (!process.isDeallocated()) {
                    OrUtil.setResourceState(job, process, IResourceState.ResourceState.Deallocated);
                    process.setProcessDeallocationType(IResourceState.ProcessDeallocationType.JobCompleted);
                    logger.info(methodName, job.getDuccId(), process.getDuccId(), new Object[]{IResourceState.ProcessDeallocationType.JobCompleted});
                    ckpt = true;
                    continue;
                }
                if (process.isComplete()) continue;
                String nodeName = process.getNodeIdentity().getCanonicalName();
                if (NodeAccounting.getInstance().isAlive(nodeName)) continue;
                process.advanceProcessState(IProcessState.ProcessState.Stopped);
                logger.info(methodName, job.getDuccId(), process.getDuccId(), new Object[]{IProcessState.ProcessState.Stopped});
                ckpt = true;
            }
        }
        if (ckpt) {
            OrchestratorHelper.jdDeallocate(job);
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
        return ckpt;
    }

    private void ajudicateJobs() {
        String methodName = "ajudicateJobs";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        long t0 = System.currentTimeMillis();
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        try {
            Set jobKeySet = workMap.getJobKeySet();
            boolean ckpt = false;
            for (DuccId jobId : jobKeySet) {
                try {
                    long initFails;
                    long cap;
                    IDuccWorkJob job = (IDuccWorkJob)WorkMapHelper.findDuccWork(workMap, jobId, (Object)this, methodName);
                    if (this.isDriverCompleted(job)) {
                        ckpt = true;
                    }
                    if (this.isCancelJobExcessiveProcessFailures(job)) {
                        ckpt = true;
                    } else if (this.isCancelJobCappedWithNoJobProcesses(job)) {
                        ckpt = true;
                    } else if (this.isCancelJobDriverProcessFailed(job)) {
                        ckpt = true;
                    }
                    if ((cap = job.getProcessInitFailureCap()) <= 0L || (initFails = job.getProcessInitFailureCount()) <= cap) continue;
                    job.getSchedulingInfo().setLongProcessesMax(-1L);
                }
                catch (Exception e) {
                    logger.error(methodName, null, (Throwable)e, new Object[0]);
                }
            }
            if (ckpt) {
                OrchestratorCheckpoint.getInstance().saveState();
            }
        }
        catch (Throwable t) {
            logger.error(methodName, null, t, new Object[0]);
        }
        long t1 = System.currentTimeMillis();
        long elapsed = t1 - t0;
        if (elapsed > 100L) {
            logger.debug(methodName, null, new Object[]{"elapsed msecs: " + elapsed});
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    private void ajudicateServices() {
        String methodName = "ajudicateServices";
        logger.trace(methodName, null, new Object[]{this.messages.fetch("enter")});
        long t0 = System.currentTimeMillis();
        DuccWorkMap workMap = this.orchestratorCommonArea.getWorkMap();
        try {
            Set serviceKeySet = workMap.getServiceKeySet();
            boolean ckpt = false;
            for (DuccId serviceId : serviceKeySet) {
                try {
                    long initFails;
                    long cap;
                    IDuccWorkJob service = (IDuccWorkJob)WorkMapHelper.findDuccWork(workMap, serviceId, (Object)this, methodName);
                    if (this.isCancelJobExcessiveProcessFailures(service)) {
                        ckpt = true;
                    } else if (this.isCancelJobExcessiveInitializationFailures(service)) {
                        ckpt = true;
                    }
                    if ((cap = service.getProcessInitFailureCap()) <= 0L || (initFails = service.getProcessInitFailureCount()) <= cap) continue;
                    service.getSchedulingInfo().setLongProcessesMax(-1L);
                }
                catch (Exception e) {
                    logger.error(methodName, null, (Throwable)e, new Object[0]);
                }
            }
            if (ckpt) {
                OrchestratorCheckpoint.getInstance().saveState();
            }
        }
        catch (Throwable t) {
            logger.error(methodName, null, t, new Object[0]);
        }
        long t1 = System.currentTimeMillis();
        long elapsed = t1 - t0;
        if (elapsed > 100L) {
            logger.debug(methodName, null, new Object[]{"elapsed msecs: " + elapsed});
        }
        logger.trace(methodName, null, new Object[]{this.messages.fetch("exit")});
    }

    public void ajudicate() {
        this.ajudicateJobs();
        this.ajudicateServices();
    }
}

