/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database;

import java.util.List;
import java.util.Map;
import org.apache.uima.ducc.common.persistence.rm.IRmPersistence;
import org.apache.uima.ducc.common.persistence.rm.NullRmStatePersistence;
import org.apache.uima.ducc.common.persistence.rm.RmPersistenceFactory;
import org.apache.uima.ducc.common.utils.DuccLogger;

public class RmQLoad {
    DuccLogger logger = DuccLogger.getLogger(RmQLoad.class, (String)"State");
    String dburl = null;

    RmQLoad(String dburl) {
        this.dburl = dburl;
    }

    void run() throws Exception {
        IRmPersistence persistence = RmPersistenceFactory.getInstance((String)this.getClass().getName(), (String)"RM");
        if (persistence instanceof NullRmStatePersistence) {
            System.out.println("Cannot get viable RM Persistance isntance.");
            return;
        }
        try {
            List state = persistence.getLoad();
            System.out.println(this.toJson(state));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            persistence.close();
        }
    }

    String toJson(List<Map<String, Object>> nodes) {
        StringBuffer buf = new StringBuffer("[");
        for (Map<String, Object> vals : nodes) {
            buf.append("{");
            for (IRmPersistence.RmLoad p : IRmPersistence.RmLoad.values()) {
                if (p.isMeta() || p.isPrivate()) continue;
                buf.append("'");
                buf.append(p.pname());
                buf.append("'");
                buf.append(":");
                switch (p.type()) {
                    case String: 
                    case UUID: {
                        buf.append("'");
                        buf.append(vals.get(p.columnName()));
                        buf.append("'");
                        break;
                    }
                    case Boolean: {
                        boolean bv = (Boolean)vals.get(p.columnName());
                        buf.append(bv ? "True" : "False");
                        break;
                    }
                    case Integer: 
                    case Long: 
                    case Double: {
                        buf.append(vals.get(p.columnName()).toString());
                        break;
                    }
                }
                buf.append(",");
            }
            buf.append("},\n");
        }
        buf.append("]");
        return buf.toString();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: RmQLoad <dburl>");
            System.exit(1);
        }
        RmQLoad rns = new RmQLoad(args[0]);
        try {
            rns.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

