/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.tables;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.caffinitas.ohc.tables.Uns;
import org.caffinitas.ohc.tables.Util;

final class BufferedWritableByteChannel
implements WritableByteChannel {
    private final WritableByteChannel delegate;
    private final long bufferAddress;
    private ByteBuffer buffer;
    private boolean closed;

    BufferedWritableByteChannel(WritableByteChannel delegate, int bufferSize) throws IOException {
        this.delegate = delegate;
        this.bufferAddress = Uns.allocateIOException(bufferSize);
        this.buffer = Uns.directBufferFor(this.bufferAddress, 0L, bufferSize, false);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int wr = 0;
        int sr;
        while ((sr = src.remaining()) != 0) {
            int br = this.buffer.remaining();
            if (br == 0) {
                this.buffer.flip();
                Util.writeFully(this.delegate, this.buffer);
                this.buffer.clear();
            }
            if (sr > br) {
                int lim = src.limit();
                src.limit(src.position() + br);
                this.buffer.put(src);
                src.position(src.limit());
                src.limit(lim);
                wr += br;
                continue;
            }
            this.buffer.put(src);
            wr += sr;
        }
        return wr;
    }

    @Override
    public boolean isOpen() {
        return this.buffer != null;
    }

    @Override
    public void close() throws IOException {
        this.buffer.flip();
        Util.writeFully(this.delegate, this.buffer);
        this.buffer = null;
        if (!this.closed) {
            Uns.free(this.bufferAddress);
        }
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            Uns.free(this.bufferAddress);
        }
        super.finalize();
    }
}

