/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.monitor.builtin;

import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import org.apache.uima.ducc.ps.service.IServiceState;
import org.apache.uima.ducc.ps.service.ServiceConfiguration;
import org.apache.uima.ducc.ps.service.monitor.IServiceMonitor;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class RemoteStateObserver
implements IServiceMonitor {
    private static final String SERVICE_JMX_PORT = "SERVICE_JMX_PORT=";
    private static final String SERVICE_UNIQUE_ID = "DUCC_PROCESS_UNIQUEID=";
    private static final String SERVICE_STATE = "DUCC_PROCESS_STATE=";
    private static final String SERVICE_DATA = "SERVICE_DATA=";
    private static final String SEPARATOR = ",";
    private ServiceConfiguration serviceConfiguration;
    private Logger logger;
    private String currentState = IServiceState.State.Starting.toString();

    public RemoteStateObserver(ServiceConfiguration serviceConfiguration, Logger logger) {
        this.serviceConfiguration = serviceConfiguration;
        this.logger = logger;
        Properties serviceProps = new Properties();
        this.sendStateUpdate(this.currentState, serviceProps);
    }

    private Socket connect() throws IOException {
        int statusUpdatePort = -1;
        String port = this.serviceConfiguration.getMonitorPort();
        try {
            statusUpdatePort = Integer.valueOf(port);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        this.logger.log(Level.INFO, "Service Connecting Socket to localhost Monitor on port:" + statusUpdatePort);
        String localhost = null;
        return new Socket(localhost, statusUpdatePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStateUpdate(String state, Properties additionalData) {
        FilterOutputStream out = null;
        Socket socket = null;
        if (this.serviceConfiguration.getMonitorPort() == null || this.serviceConfiguration.getDuccProcessUniqueId() == null) {
            return;
        }
        try {
            socket = this.connect();
            if (socket == null) {
                return;
            }
            if (additionalData == null) {
                additionalData = new Properties();
            }
            StringBuilder sb = new StringBuilder().append(SERVICE_UNIQUE_ID).append(this.serviceConfiguration.getDuccProcessUniqueId()).append(SEPARATOR).append(SERVICE_STATE).append(state);
            if (this.serviceConfiguration.getServiceJmxConnectURL() != null && !this.serviceConfiguration.getServiceJmxConnectURL().trim().isEmpty()) {
                sb.append(SEPARATOR).append(SERVICE_JMX_PORT).append(this.serviceConfiguration.getServiceJmxConnectURL().trim());
            }
            out = new DataOutputStream(socket.getOutputStream());
            ((DataOutputStream)out).writeUTF(sb.toString());
            ((DataOutputStream)out).flush();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void onStateChange(String state, Properties additionalData) {
        this.sendStateUpdate(state, additionalData);
    }

    @Override
    public void onStateChange(Properties additionalData) {
        this.sendStateUpdate(this.currentState, additionalData);
    }

    @Override
    public void stop() {
    }

    public static void main(String[] args) {
    }

    @Override
    public void start() {
    }
}

