/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.utils;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static String getTimestamp() {
        Date now = new Date();
        return DateFormat.getDateTimeInstance().format(now);
    }

    public static String getShortClassname(Class clz) {
        return clz.getName().substring(clz.getName().lastIndexOf(".") + 1);
    }

    public static ArrayList<String> tokenizeList(String options, boolean stripQuotes) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (options == null) {
            return tokens;
        }
        String noSpaceRegex = "[^\\s\"']+";
        String doubleQuoteRegex = "\"([^\"]*)\"";
        String singleQuoteRegex = "'([^']*)'";
        String regex = noSpaceRegex + "|" + doubleQuoteRegex + "|" + singleQuoteRegex;
        Pattern patn = Pattern.compile(regex);
        Matcher matcher = patn.matcher(options);
        StringBuilder sb = new StringBuilder();
        if (stripQuotes) {
            while (matcher.find()) {
                if (matcher.group(1) != null) {
                    sb.append(matcher.group(1));
                } else if (matcher.group(2) != null) {
                    sb.append(matcher.group(2));
                } else {
                    sb.append(matcher.group());
                }
                if (matcher.end() < options.length() && !Character.isWhitespace(options.charAt(matcher.end()))) continue;
                tokens.add(sb.toString());
                sb.setLength(0);
            }
        } else {
            while (matcher.find()) {
                sb.append(matcher.group());
                if (matcher.end() < options.length() && !Character.isWhitespace(options.charAt(matcher.end()))) continue;
                tokens.add(sb.toString());
                sb.setLength(0);
            }
        }
        return tokens;
    }

    public static String resolvePlaceholders(String contents) {
        return Utils.resolvePlaceholders(contents, System.getProperties());
    }

    public static String resolvePlaceholders(String contents, Properties props) {
        Pattern placeHolderPattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher matcher = placeHolderPattern.matcher(contents);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String key = matcher.group(1);
            String placeholderValue = props.getProperty(key);
            if (placeholderValue == null && (placeholderValue = System.getProperty(key)) == null) {
                throw new IllegalArgumentException("Missing value for placeholder: " + key);
            }
            matcher.appendReplacement(sb, placeholderValue);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String resolvePlaceholderIfExists(String value, Properties props) {
        String retVal = value;
        if (value != null && value.contains("${")) {
            retVal = Utils.resolvePlaceholders(value, props);
        }
        return retVal;
    }

    public static URLClassLoader create(String classPath) throws MalformedURLException {
        return Utils.create(classPath.split(":"));
    }

    public static URLClassLoader create(String[] classPathElements) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>(classPathElements.length);
        for (String element : classPathElements) {
            if (element.endsWith("*")) {
                File dir = new File(element.substring(0, element.length() - 1));
                File[] files = dir.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    if (!f.getName().endsWith(".jar")) continue;
                    urlList.add(f.toURI().toURL());
                }
                continue;
            }
            File f = new File(element);
            if (!f.exists()) continue;
            urlList.add(f.toURI().toURL());
        }
        URL[] urls = new URL[urlList.size()];
        return new URLClassLoader(urlList.toArray(urls), ClassLoader.getSystemClassLoader().getParent());
    }

    public static void dump(ClassLoader cl, int numLevels) {
        int n = 0;
        for (URLClassLoader ucl = (URLClassLoader)cl; ucl != null && ++n <= numLevels; ucl = (URLClassLoader)ucl.getParent()) {
            System.out.println("Class-loader " + n + " has " + ucl.getURLs().length + " urls:");
            for (URL u : ucl.getURLs()) {
                System.out.println("  " + u);
            }
        }
    }

    public static HashMap<String, String> hideLoggingProperties() {
        String[] propsToSave = new String[]{"log4j.configuration", "java.util.logging.config.file", "java.util.logging.config.class", "org.apache.uima.logger.class"};
        HashMap<String, String> savedPropsMap = new HashMap<String, String>();
        for (String prop : propsToSave) {
            String val = System.getProperty(prop);
            if (val == null) continue;
            savedPropsMap.put(prop, val);
            System.getProperties().remove(prop);
        }
        return savedPropsMap;
    }

    public static void restoreLoggingProperties(HashMap<String, String> savedPropsMap) {
        for (String prop : savedPropsMap.keySet()) {
            System.setProperty(prop, savedPropsMap.get(prop));
        }
    }

    public static String getPID(String fallback) {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int pos = name.indexOf(64);
        if (pos < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(name.substring(0, pos)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static String getArg(String id, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!id.equals(args[i])) continue;
            return i + 1 < args.length ? args[i + 1] : "";
        }
        return "";
    }

    public static String[] getMultipleArg(String id, String[] args) {
        String[] retr = new String[]{};
        for (int i = 0; i < args.length; ++i) {
            if (!id.equals(args[i])) continue;
            String[] temp = new String[retr.length + 1];
            for (int s = 0; s < retr.length; ++s) {
                temp[s] = retr[s];
            }
            retr = temp;
            retr[retr.length - 1] = i + 1 < args.length ? args[i + 1] : null;
        }
        return retr;
    }

    public static String[] getMultipleArg2(String id, String[] args) {
        String[] retr = new String[]{};
        for (int i = 0; i < args.length; ++i) {
            if (!id.equals(args[i])) continue;
            int j = 0;
            while (i + 1 + j < args.length && !args[i + 1 + j].startsWith("-")) {
                String[] temp = new String[retr.length + 1];
                for (int s = 0; s < retr.length; ++s) {
                    temp[s] = retr[s];
                }
                retr = temp;
                retr[retr.length - 1] = args[i + 1 + j++];
            }
            return retr;
        }
        return retr;
    }
}

