/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.configuration.jp;

import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.uima.ducc.common.IDuccUser;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.container.FlagsHelper;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.container.jp.JobProcessManager;
import org.apache.uima.ducc.transport.DuccTransportConfiguration;
import org.apache.uima.ducc.transport.configuration.jp.AgentSession;
import org.apache.uima.ducc.transport.configuration.jp.JobProcessComponent;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuccTransportConfiguration.class, CommonConfiguration.class})
public class JobProcessConfiguration {
    public static final String AGENT_ENDPOINT = "mina:tcp://localhost:";
    @Autowired
    DuccTransportConfiguration transport;
    @Autowired
    CommonConfiguration common;
    JobProcessComponent duccComponent = null;
    JobProcessManager jobProcessManager = null;
    AgentSession agent = null;
    RouteBuilder routeBuilder;
    CamelContext camelContext;

    private void checkPrereqs() {
        boolean uimaAsJob = false;
        if (null == System.getProperty(FlagsHelper.Name.JpType.pname())) {
            throw new RuntimeException("Missing Job Type. Add -D" + FlagsHelper.Name.JpType.pname() + "=uima-as or " + FlagsHelper.Name.JpType.pname() + "=uima. Check your command line");
        }
        String jobType = System.getProperty(FlagsHelper.Name.JpType.pname());
        if (jobType.trim().equals("uima-as")) {
            uimaAsJob = true;
        } else if (!jobType.trim().equals("uima") && !jobType.trim().equals("custom")) {
            throw new RuntimeException("Invalid value for -D" + FlagsHelper.Name.JpType.pname() + ". Expected uima-as,uima or custom, Instead it is " + jobType);
        }
        if (null == System.getProperty(FlagsHelper.Name.DuccClasspath.pname())) {
            throw new RuntimeException("Missing the -D" + FlagsHelper.Name.DuccClasspath.pname() + "=XXXX property");
        }
        if (uimaAsJob && null == this.common.saxonJarPath) {
            throw new RuntimeException("Missing saxon jar path. Check your ducc.properties");
        }
        if (uimaAsJob && null == this.common.dd2SpringXslPath) {
            throw new RuntimeException("Missing dd2spring xsl path. Check your ducc.properties");
        }
        if (null == System.getProperty(FlagsHelper.Name.JdURL.pname())) {
            throw new RuntimeException("Missing the -D" + FlagsHelper.Name.JdURL.pname() + " property");
        }
    }

    public String getUserContainerClassForJob(String key) {
        if (key.equals("uima-as")) {
            if (this.common.uimaASProcessContainerClass == null) {
                return "org.apache.uima.ducc.user.jp.UimaASProcessContainer";
            }
            return this.common.uimaASProcessContainerClass;
        }
        if (this.common.uimaProcessContainerClass == null) {
            return "org.apache.uima.ducc.user.jp.UimaProcessContainer";
        }
        return this.common.uimaProcessContainerClass;
    }

    @Bean
    public JobProcessComponent getProcessManagerInstance() throws Exception {
        this.checkPrereqs();
        this.camelContext = this.common.camelContext();
        String jobType = System.getProperty(FlagsHelper.Name.JpType.pname());
        if (System.getProperty(FlagsHelper.Name.JpProcessorClass.pname()) == null) {
            String containerClass = this.getUserContainerClassForJob(jobType);
            System.setProperty(FlagsHelper.Name.JpProcessorClass.pname(), containerClass);
        }
        this.duccComponent = new JobProcessComponent("UimaProcess", this.camelContext, this);
        int serviceSocketPort = 0;
        String agentSocketParams = "";
        String jpSocketParams = "";
        if (this.common.managedServiceEndpointParams != null) {
            jpSocketParams = "?" + this.common.managedServiceEndpointParams;
        }
        if (this.common.managedProcessStateUpdateEndpointParams != null) {
            agentSocketParams = "?" + this.common.managedProcessStateUpdateEndpointParams;
        }
        boolean disableAgentUpdates = false;
        if (this.common.managedProcessStateUpdateEndpointType != null && this.common.managedProcessStateUpdateEndpointType.equalsIgnoreCase("socket")) {
            String updatePort = System.getenv(IDuccUser.EnvironmentVariable.DUCC_UPDATE_PORT.value());
            if (updatePort == null || updatePort.trim().isEmpty()) {
                disableAgentUpdates = true;
            }
            this.common.managedProcessStateUpdateEndpoint = AGENT_ENDPOINT + updatePort + agentSocketParams;
        }
        if (this.common.managedServiceEndpointType != null && this.common.managedServiceEndpointType.equalsIgnoreCase("socket")) {
            serviceSocketPort = Utils.findFreePort();
            this.common.managedServiceEndpoint = AGENT_ENDPOINT + serviceSocketPort + jpSocketParams;
        }
        if (this.common.jpFrameworkErrorLimit != null) {
            int limit = Integer.parseInt(this.common.jpFrameworkErrorLimit);
            this.duccComponent.setMaxFrameworkFailures(limit);
        } else {
            this.duccComponent.setMaxFrameworkFailures(2);
        }
        DuccEventDispatcher eventDispatcher = this.transport.duccEventDispatcher(this.common.managedProcessStateUpdateEndpoint, this.camelContext);
        String processId = System.getProperty(IDuccUser.DashD.DUCC_ID_PROCESS_UNIQUE.value());
        if (processId == null) {
            processId = System.getenv(IDuccUser.EnvironmentVariable.DUCC_PROCESS_UNIQUEID.value());
        }
        this.agent = new AgentSession(eventDispatcher, processId, this.common.managedServiceEndpoint);
        if (disableAgentUpdates) {
            this.agent.disable(disableAgentUpdates);
        } else {
            this.duccComponent.getLogger().info("getProcessManagerInstance", null, new Object[]{"#######################################################"});
            this.duccComponent.getLogger().info("getProcessManagerInstance", null, new Object[]{"## Agent Service State Update Endpoint:" + this.common.managedProcessStateUpdateEndpoint + " ##"});
            this.duccComponent.getLogger().info("getProcessManagerInstance", null, new Object[]{"#######################################################"});
        }
        this.duccComponent.setAgentSession(this.agent);
        this.duccComponent.setSaxonJarPath(this.common.saxonJarPath);
        this.duccComponent.setDd2SpringXslPath(this.common.dd2SpringXslPath);
        if (this.common.processThreadSleepTime != null) {
            this.duccComponent.setThreadSleepTime(Integer.parseInt(this.common.processThreadSleepTime));
            this.duccComponent.getLogger().info("getProcessManagerInstance", null, new Object[]{"Overriding Default Thread Sleep Time - New Value " + this.common.processThreadSleepTime + " ms"});
        }
        if (this.common.processRequestTimeout != null) {
            this.duccComponent.setTimeout(Integer.valueOf(this.common.processRequestTimeout));
            this.duccComponent.getLogger().info("getProcessManagerInstance", null, new Object[]{"Overriding Default Process Request Timeout - New Timeout " + this.common.processRequestTimeout + " ms"});
        }
        return this.duccComponent;
    }
}

