/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.metrics;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.Summary;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.uniffle.common.metrics.SupplierGauge;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.shaded.com.google.common.collect.Maps;

public class MetricsManager {
    private final CollectorRegistry collectorRegistry;
    private final String[] defaultLabelNames;
    private final String[] defaultLabelValues;
    private static final double[] QUANTILES = new double[]{0.5, 0.75, 0.9, 0.95, 0.99};
    private static final double QUANTILE_ERROR = 0.01;
    private Map<String, SupplierGauge> supplierGaugeMap;

    public MetricsManager() {
        this(null, Maps.newHashMap());
    }

    public MetricsManager(CollectorRegistry collectorRegistry, Map<String, String> defaultLabels) {
        this.collectorRegistry = collectorRegistry == null ? CollectorRegistry.defaultRegistry : collectorRegistry;
        this.defaultLabelNames = defaultLabels.keySet().toArray(new String[0]);
        this.defaultLabelValues = (String[])Arrays.stream(this.defaultLabelNames).map(defaultLabels::get).toArray(String[]::new);
        this.supplierGaugeMap = JavaUtils.newConcurrentMap();
    }

    public CollectorRegistry getCollectorRegistry() {
        return this.collectorRegistry;
    }

    public Counter addCounter(String name, String ... labels) {
        return this.addCounter(name, "Counter " + name, labels);
    }

    public Counter addCounter(String name, String help, String[] labels) {
        return (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(name)).labelNames(labels)).help(help)).register(this.collectorRegistry);
    }

    public Counter.Child addLabeledCounter(String name) {
        Counter c = this.addCounter(name, this.defaultLabelNames);
        return (Counter.Child)c.labels(this.defaultLabelValues);
    }

    public Gauge addGauge(String name, String ... labels) {
        return this.addGauge(name, "Gauge " + name, labels);
    }

    public Gauge addGauge(String name, String help, String[] labels) {
        return (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name(name)).labelNames(labels)).help(help)).register(this.collectorRegistry);
    }

    public Gauge.Child addLabeledGauge(String name) {
        Gauge c = this.addGauge(name, this.defaultLabelNames);
        return (Gauge.Child)c.labels(this.defaultLabelValues);
    }

    public <T extends Number> void addLabeledGauge(String name, Supplier<T> supplier) {
        this.addLabeledCacheGauge(name, supplier, 0L);
    }

    public <T extends Number> void addLabeledCacheGauge(String name, Supplier<T> supplier, long updateInterval) {
        this.supplierGaugeMap.computeIfAbsent(name, metricName -> (SupplierGauge)new SupplierGauge(name, "Gauge " + name, supplier, this.defaultLabelNames, this.defaultLabelValues, updateInterval).register(this.collectorRegistry));
    }

    public Histogram addHistogram(String name, double[] buckets, String ... labels) {
        return this.addHistogram(name, "Histogram " + name, buckets, labels);
    }

    public Histogram addHistogram(String name, double[] buckets) {
        return this.addHistogram(name, "Histogram " + name, buckets, this.defaultLabelNames);
    }

    public Histogram addHistogram(String name, String help, double[] buckets, String[] labels) {
        return (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(name)).buckets(buckets).labelNames(labels)).help(help)).register(this.collectorRegistry);
    }

    public Summary addSummary(String name) {
        Summary.Builder builder = (Summary.Builder)((Summary.Builder)Summary.build().name(name)).help("Summary " + name);
        for (int i = 0; i < QUANTILES.length; ++i) {
            builder = builder.quantile(QUANTILES[i], 0.01);
        }
        return (Summary)builder.register(this.collectorRegistry);
    }

    public Summary.Child addLabeledSummary(String name) {
        Summary.Builder builder = (Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name(name)).labelNames(this.defaultLabelNames)).help("Summary " + name);
        for (int i = 0; i < QUANTILES.length; ++i) {
            builder = builder.quantile(QUANTILES[i], 0.01);
        }
        return (Summary.Child)((Summary)builder.register(this.collectorRegistry)).labels(this.defaultLabelValues);
    }

    public void unregisterAllSupplierGauge() {
        for (SupplierGauge gauge : this.supplierGaugeMap.values()) {
            this.collectorRegistry.unregister((Collector)gauge);
        }
        this.supplierGaugeMap.clear();
    }

    public void unregisterSupplierGauge(String name) {
        if (this.supplierGaugeMap.containsKey(name)) {
            this.collectorRegistry.unregister((Collector)this.supplierGaugeMap.get(name));
            this.supplierGaugeMap.remove(name);
        }
    }

    public String[] getDefaultLabelNames() {
        return this.defaultLabelNames;
    }

    public String[] getDefaultLabelValues() {
        return this.defaultLabelValues;
    }
}

