/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.reader;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.shuffle.RssSparkShuffleUtils;
import org.apache.uniffle.client.api.ShuffleManagerClient;
import org.apache.uniffle.client.request.RssReportShuffleFetchFailureRequest;
import org.apache.uniffle.client.response.RssReportShuffleFetchFailureResponse;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Product2;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;

public class RssFetchFailedIterator<K, C>
extends AbstractIterator<Product2<K, C>> {
    private static final Logger LOG = LoggerFactory.getLogger(RssFetchFailedIterator.class);
    final Iterator<Product2<K, C>> iter;
    final Builder builder;

    private RssFetchFailedIterator(Builder builder, Iterator<Product2<K, C>> iterator) {
        this.builder = builder;
        this.iter = iterator;
    }

    static Builder newBuilder() {
        return new Builder();
    }

    private RssException generateFetchFailedIfNecessary(RssFetchFailedException e) {
        RssReportShuffleFetchFailureRequest req;
        ShuffleManagerClient client = (ShuffleManagerClient)this.builder.managerClientSupplier.get();
        RssReportShuffleFetchFailureResponse response = client.reportShuffleFetchFailure(req = new RssReportShuffleFetchFailureRequest(this.builder.appId, this.builder.shuffleId, this.builder.stageAttemptId, this.builder.partitionId, e.getMessage()));
        if (response.getReSubmitWholeStage()) {
            FetchFailedException ffe = RssSparkShuffleUtils.createFetchFailedException(this.builder.shuffleId, -1, this.builder.partitionId, e);
            return new RssException((Throwable)ffe);
        }
        return e;
    }

    public boolean hasNext() {
        try {
            return this.iter.hasNext();
        }
        catch (RssFetchFailedException e) {
            throw this.generateFetchFailedIfNecessary(e);
        }
    }

    public Product2<K, C> next() {
        try {
            return (Product2)this.iter.next();
        }
        catch (RssFetchFailedException e) {
            throw this.generateFetchFailedIfNecessary(e);
        }
    }

    public static class Builder {
        private String appId;
        private int shuffleId;
        private int partitionId;
        private int stageAttemptId;
        private Supplier<ShuffleManagerClient> managerClientSupplier;

        private Builder() {
        }

        Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        Builder shuffleId(int shuffleId) {
            this.shuffleId = shuffleId;
            return this;
        }

        Builder partitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        Builder stageAttemptId(int stageAttemptId) {
            this.stageAttemptId = stageAttemptId;
            return this;
        }

        Builder managerClientSupplier(Supplier<ShuffleManagerClient> managerClientSupplier) {
            this.managerClientSupplier = managerClientSupplier;
            return this;
        }

        <K, C> RssFetchFailedIterator<K, C> build(Iterator<Product2<K, C>> iter) {
            Objects.requireNonNull(this.appId);
            return new RssFetchFailedIterator(this, iter);
        }
    }
}

