/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.common;

import java.util.concurrent.atomic.AtomicLong;

public class ShuffleServerPushCost {
    private final String shuffleServerId;
    private final AtomicLong sentBytes;
    private final AtomicLong sentDurationMs;
    private final AtomicLong requireBufferFailureCounter;
    private final AtomicLong pushFailureCounter;
    private String lastPushFailureReason;

    public ShuffleServerPushCost(String shuffleServerId) {
        this.shuffleServerId = shuffleServerId;
        this.sentBytes = new AtomicLong();
        this.sentDurationMs = new AtomicLong();
        this.requireBufferFailureCounter = new AtomicLong();
        this.pushFailureCounter = new AtomicLong();
        this.lastPushFailureReason = null;
    }

    public void incRequiredBufferFailure(long delta) {
        this.requireBufferFailureCounter.addAndGet(delta);
    }

    public void incSentFailure(long delta, String failureReason) {
        this.pushFailureCounter.addAndGet(delta);
        this.lastPushFailureReason = failureReason;
    }

    public void incSentBytes(long bytes) {
        this.sentBytes.addAndGet(bytes);
    }

    public void incDurationMs(long duration) {
        this.sentDurationMs.addAndGet(duration);
    }

    public void merge(ShuffleServerPushCost cost) {
        if (!cost.shuffleServerId.equals(this.shuffleServerId)) {
            return;
        }
        this.incSentBytes(cost.sentBytes.get());
        this.incDurationMs(cost.sentDurationMs.get());
        this.incRequiredBufferFailure(cost.requireBufferFailureCounter.get());
        this.incSentFailure(cost.pushFailureCounter.get(), cost.lastPushFailureReason);
    }

    public long speed() {
        if (this.sentDurationMs.get() == 0L) {
            return 0L;
        }
        return this.sentBytes.get() / this.sentDurationMs.get();
    }

    public long sentBytes() {
        return this.sentBytes.get();
    }

    public long sentDurationMillis() {
        return this.sentDurationMs.get();
    }

    public long requiredBufferFailureNumber() {
        return this.requireBufferFailureCounter.get();
    }

    public long pushFailureNumber() {
        return this.pushFailureCounter.get();
    }

    public String getLastPushFailureReason() {
        return this.lastPushFailureReason;
    }

    public String toString() {
        return "ShuffleServerPushCost{shuffleServerId='" + this.shuffleServerId + ", sentBytes=" + this.sentBytes + ", sentDurationMs=" + this.sentDurationMs + ", speed=" + this.speed() + "}";
    }
}

