/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.metrics;

import org.apache.uniffle.shaded.io.prometheus.client.CollectorRegistry;
import org.apache.uniffle.shaded.io.prometheus.client.hotspot.BufferPoolsExports;
import org.apache.uniffle.shaded.io.prometheus.client.hotspot.ClassLoadingExports;
import org.apache.uniffle.shaded.io.prometheus.client.hotspot.GarbageCollectorExports;
import org.apache.uniffle.shaded.io.prometheus.client.hotspot.MemoryAllocationExports;
import org.apache.uniffle.shaded.io.prometheus.client.hotspot.MemoryPoolsExports;
import org.apache.uniffle.shaded.io.prometheus.client.hotspot.StandardExports;
import org.apache.uniffle.shaded.io.prometheus.client.hotspot.ThreadExports;
import org.apache.uniffle.shaded.io.prometheus.client.hotspot.VersionInfoExports;

public class JvmMetrics {
    private static CollectorRegistry collectorRegistry;
    private static boolean initialized;

    public static CollectorRegistry getCollectorRegistry() {
        return collectorRegistry;
    }

    public static void register() {
        JvmMetrics.register(CollectorRegistry.defaultRegistry, false);
    }

    public static void register(CollectorRegistry collectorRegistry) {
        JvmMetrics.register(collectorRegistry, false);
    }

    public static synchronized void register(CollectorRegistry collectorRegistry, boolean verbose) {
        if (!initialized) {
            JvmMetrics.collectorRegistry = collectorRegistry;
            if (verbose) {
                JvmMetrics.registerVerbose(collectorRegistry);
            } else {
                JvmMetrics.registerDefault(collectorRegistry);
            }
            initialized = true;
        }
    }

    private static void registerDefault(CollectorRegistry registry) {
        new StandardExports().register(registry);
        new BufferPoolsExports().register(registry);
        new GarbageCollectorExports().register(registry);
        new ThreadExports().register(registry);
        new VersionInfoExports().register(registry);
    }

    private static void registerVerbose(CollectorRegistry registry) {
        new StandardExports().register(registry);
        new MemoryPoolsExports().register(registry);
        new MemoryAllocationExports().register(registry);
        new BufferPoolsExports().register(registry);
        new GarbageCollectorExports().register(registry);
        new ThreadExports().register(registry);
        new ClassLoadingExports().register(registry);
        new VersionInfoExports().register(registry);
    }

    static {
        initialized = false;
    }
}

