/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.writer;

import com.clearspring.analytics.util.Lists;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.shuffle.RssSparkConfig;
import org.apache.spark.shuffle.writer.AddBlockEvent;
import org.apache.spark.shuffle.writer.BufferManagerOptions;
import org.apache.spark.shuffle.writer.WrappedByteArrayOutputStream;
import org.apache.spark.shuffle.writer.WriterBuffer;
import org.apache.uniffle.client.common.ShuffleServerPushCostTracker;
import org.apache.uniffle.common.DeferredCompressedBlock;
import org.apache.uniffle.common.ShuffleBlockInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.compression.Codec;
import org.apache.uniffle.common.compression.StatisticsCodec;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.util.BlockIdLayout;
import org.apache.uniffle.common.util.ChecksumUtils;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;

public class WriteBufferManager
extends MemoryConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(WriteBufferManager.class);
    private int bufferSize;
    private long spillSize;
    private AtomicLong allocatedBytes = new AtomicLong(0L);
    private AtomicLong usedBytes = new AtomicLong(0L);
    private AtomicLong inSendListBytes = new AtomicLong(0L);
    private AtomicLong recordCounter = new AtomicLong(0L);
    private AtomicLong blockCounter = new AtomicLong(0L);
    private Map<Integer, AtomicInteger> partitionToSeqNo = Maps.newHashMap();
    private long askExecutorMemory;
    private int shuffleId;
    private String taskId;
    private long taskAttemptId;
    private SerializerInstance instance;
    private ShuffleWriteMetrics shuffleWriteMetrics;
    private Map<Integer, WriterBuffer> buffers;
    private int serializerBufferSize;
    private int bufferSegmentSize;
    private long copyTime = 0L;
    private long serializeTime = 0L;
    private long compressTime = 0L;
    private long sortTime = 0L;
    private long writeTime = 0L;
    private long estimateTime = 0L;
    private long requireMemoryTime = 0L;
    private SerializationStream serializeStream;
    private WrappedByteArrayOutputStream arrayOutputStream;
    private long uncompressedDataLen = 0L;
    private long compressedDataLen = 0L;
    private long requireMemoryInterval;
    private int requireMemoryRetryMax;
    private Optional<Codec> codec;
    private Function<List<ShuffleBlockInfo>, List<CompletableFuture<Long>>> spillFunc;
    private long sendSizeLimit;
    private boolean memorySpillEnabled;
    private int memorySpillTimeoutSec;
    private boolean isRowBased;
    private BlockIdLayout blockIdLayout;
    private double bufferSpillRatio;
    private Function<Integer, List<ShuffleServerInfo>> partitionAssignmentRetrieveFunc;
    private int stageAttemptNumber;
    private ShuffleServerPushCostTracker shuffleServerPushCostTracker;
    private boolean overlappingCompressionEnabled;

    public WriteBufferManager(int shuffleId, long taskAttemptId, BufferManagerOptions bufferManagerOptions, Serializer serializer, Map<Integer, List<ShuffleServerInfo>> partitionToServers, TaskMemoryManager taskMemoryManager, ShuffleWriteMetrics shuffleWriteMetrics, RssConf rssConf) {
        this(shuffleId, null, taskAttemptId, bufferManagerOptions, serializer, partitionToServers, taskMemoryManager, shuffleWriteMetrics, rssConf, null, 0);
    }

    public WriteBufferManager(int shuffleId, String taskId, long taskAttemptId, BufferManagerOptions bufferManagerOptions, Serializer serializer, TaskMemoryManager taskMemoryManager, ShuffleWriteMetrics shuffleWriteMetrics, RssConf rssConf, Function<List<ShuffleBlockInfo>, List<CompletableFuture<Long>>> spillFunc, Function<Integer, List<ShuffleServerInfo>> partitionAssignmentRetrieveFunc) {
        this(shuffleId, taskId, taskAttemptId, bufferManagerOptions, serializer, taskMemoryManager, shuffleWriteMetrics, rssConf, spillFunc, partitionAssignmentRetrieveFunc, 0);
    }

    public WriteBufferManager(int shuffleId, String taskId, long taskAttemptId, BufferManagerOptions bufferManagerOptions, Serializer serializer, TaskMemoryManager taskMemoryManager, ShuffleWriteMetrics shuffleWriteMetrics, RssConf rssConf, Function<List<ShuffleBlockInfo>, List<CompletableFuture<Long>>> spillFunc, Function<Integer, List<ShuffleServerInfo>> partitionAssignmentRetrieveFunc, int stageAttemptNumber) {
        super(taskMemoryManager, taskMemoryManager.pageSizeBytes(), MemoryMode.ON_HEAP);
        boolean compress;
        this.bufferSize = bufferManagerOptions.getBufferSize();
        this.spillSize = bufferManagerOptions.getBufferSpillThreshold();
        this.buffers = Maps.newHashMap();
        this.shuffleId = shuffleId;
        this.taskId = taskId;
        this.taskAttemptId = taskAttemptId;
        this.shuffleWriteMetrics = shuffleWriteMetrics;
        this.serializerBufferSize = bufferManagerOptions.getSerializerBufferSize();
        this.bufferSegmentSize = bufferManagerOptions.getBufferSegmentSize();
        this.askExecutorMemory = bufferManagerOptions.getPreAllocatedBufferSize();
        this.requireMemoryInterval = bufferManagerOptions.getRequireMemoryInterval();
        this.requireMemoryRetryMax = bufferManagerOptions.getRequireMemoryRetryMax();
        this.arrayOutputStream = new WrappedByteArrayOutputStream(this.serializerBufferSize);
        this.overlappingCompressionEnabled = rssConf.getBoolean(RssSparkConfig.RSS_WRITE_OVERLAPPING_COMPRESSION_ENABLED);
        this.isRowBased = rssConf.getBoolean(RssSparkConfig.RSS_ROW_BASED);
        if (this.isRowBased) {
            this.instance = serializer.newInstance();
            this.serializeStream = this.instance.serializeStream((OutputStream)this.arrayOutputStream);
        }
        this.codec = (compress = rssConf.getBoolean("spark.shuffle.compress".substring("spark.".length()), true)) ? Codec.create(rssConf) : Optional.empty();
        this.spillFunc = spillFunc;
        this.sendSizeLimit = rssConf.get(RssSparkConfig.RSS_CLIENT_SEND_SIZE_LIMITATION);
        this.memorySpillTimeoutSec = rssConf.get(RssSparkConfig.RSS_MEMORY_SPILL_TIMEOUT);
        this.memorySpillEnabled = rssConf.get(RssSparkConfig.RSS_MEMORY_SPILL_ENABLED);
        this.bufferSpillRatio = rssConf.get(RssSparkConfig.RSS_MEMORY_SPILL_RATIO);
        this.blockIdLayout = BlockIdLayout.from(rssConf);
        this.partitionAssignmentRetrieveFunc = partitionAssignmentRetrieveFunc;
        this.stageAttemptNumber = stageAttemptNumber;
        this.shuffleServerPushCostTracker = new ShuffleServerPushCostTracker();
    }

    public WriteBufferManager(int shuffleId, String taskId, long taskAttemptId, BufferManagerOptions bufferManagerOptions, Serializer serializer, Map<Integer, List<ShuffleServerInfo>> partitionToServers, TaskMemoryManager taskMemoryManager, ShuffleWriteMetrics shuffleWriteMetrics, RssConf rssConf, Function<List<ShuffleBlockInfo>, List<CompletableFuture<Long>>> spillFunc, int stageAttemptNumber) {
        this(shuffleId, taskId, taskAttemptId, bufferManagerOptions, serializer, taskMemoryManager, shuffleWriteMetrics, rssConf, spillFunc, (Integer partitionId) -> (List)partitionToServers.get(partitionId), stageAttemptNumber);
    }

    public List<ShuffleBlockInfo> addPartitionData(int partitionId, byte[] serializedData) {
        return this.addPartitionData(partitionId, serializedData, serializedData.length, System.currentTimeMillis());
    }

    public List<ShuffleBlockInfo> addPartitionData(int partitionId, byte[] serializedData, int serializedDataLength, long start) {
        List<ShuffleBlockInfo> singleOrEmptySendingBlocks = this.insertIntoBuffer(partitionId, serializedData, serializedDataLength);
        if (this.usedBytes.get() - this.inSendListBytes.get() > this.spillSize) {
            LOG.info("ShuffleBufferManager spill for buffer size exceeding spill threshold, usedBytes[{}], inSendListBytes[{}], spill size threshold[{}]", new Object[]{this.usedBytes.get(), this.inSendListBytes.get(), this.spillSize});
            List<ShuffleBlockInfo> multiSendingBlocks = this.clear(this.bufferSpillRatio);
            multiSendingBlocks.addAll(singleOrEmptySendingBlocks);
            this.writeTime += System.currentTimeMillis() - start;
            return multiSendingBlocks;
        }
        this.writeTime += System.currentTimeMillis() - start;
        return singleOrEmptySendingBlocks;
    }

    private List<ShuffleBlockInfo> insertIntoBuffer(int partitionId, byte[] serializedData, int serializedDataLength) {
        long required = Math.max(this.bufferSegmentSize, serializedDataLength);
        boolean hasRequested = false;
        WriterBuffer wb = this.buffers.get(partitionId);
        if (wb != null && wb.askForMemory(serializedDataLength)) {
            this.requestMemory(required);
            hasRequested = true;
        }
        if (hasRequested) {
            wb = this.buffers.get(partitionId);
        }
        if (wb != null) {
            if (hasRequested) {
                this.usedBytes.addAndGet(required);
            }
            wb.addRecord(serializedData, serializedDataLength);
        } else {
            if (!hasRequested) {
                this.requestMemory(required);
            }
            this.usedBytes.addAndGet(required);
            wb = new WriterBuffer(this.bufferSegmentSize);
            wb.addRecord(serializedData, serializedDataLength);
            this.buffers.put(partitionId, wb);
        }
        if (wb.getMemoryUsed() > this.bufferSize) {
            ArrayList<ShuffleBlockInfo> sentBlocks = new ArrayList<ShuffleBlockInfo>(1);
            sentBlocks.add(this.createShuffleBlock(partitionId, wb));
            this.recordCounter.addAndGet(wb.getRecordCount());
            this.copyTime += wb.getCopyTime();
            this.buffers.remove(partitionId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Single buffer is full for shuffleId[" + this.shuffleId + "] partition[" + partitionId + "] with memoryUsed[" + wb.getMemoryUsed() + "], dataLength[" + wb.getDataLength() + "]");
            }
            return sentBlocks;
        }
        return Collections.emptyList();
    }

    public List<ShuffleBlockInfo> addRecord(int partitionId, Object key, Object value) {
        long start = System.currentTimeMillis();
        this.arrayOutputStream.reset();
        if (key != null) {
            this.serializeStream.writeKey(key, ClassTag$.MODULE$.apply(key.getClass()));
        } else {
            this.serializeStream.writeKey(null, (ClassTag)ManifestFactory$.MODULE$.Null());
        }
        if (value != null) {
            this.serializeStream.writeValue(value, ClassTag$.MODULE$.apply(value.getClass()));
        } else {
            this.serializeStream.writeValue(null, (ClassTag)ManifestFactory$.MODULE$.Null());
        }
        this.serializeStream.flush();
        this.serializeTime += System.currentTimeMillis() - start;
        byte[] serializedData = this.arrayOutputStream.getBuf();
        int serializedDataLength = this.arrayOutputStream.size();
        if (serializedDataLength == 0) {
            return null;
        }
        List<ShuffleBlockInfo> shuffleBlockInfos = this.addPartitionData(partitionId, serializedData, serializedDataLength, start);
        if (this.isRowBased) {
            this.shuffleWriteMetrics.incRecordsWritten(1L);
        }
        return shuffleBlockInfos;
    }

    public synchronized List<ShuffleBlockInfo> clear() {
        return this.clear(this.bufferSpillRatio);
    }

    public synchronized List<ShuffleBlockInfo> clear(double bufferSpillRatio) {
        List result = Lists.newArrayList();
        long dataSize = 0L;
        long memoryUsed = 0L;
        long targetSpillSize = Long.MAX_VALUE;
        bufferSpillRatio = Math.max(0.1, Math.min(1.0, bufferSpillRatio));
        ArrayList<Integer> partitionList = new ArrayList<Integer>(this.buffers.keySet());
        if (Double.compare(bufferSpillRatio, 1.0) < 0) {
            long start = System.currentTimeMillis();
            partitionList.sort(Comparator.comparingInt(o -> this.buffers.get(o) == null ? 0 : this.buffers.get(o).getMemoryUsed()).reversed());
            this.sortTime += System.currentTimeMillis() - start;
            targetSpillSize = (long)((double)(this.getUsedBytes() - this.getInSendListBytes()) * bufferSpillRatio);
        }
        Iterator iterator = partitionList.iterator();
        while (iterator.hasNext()) {
            int partitionId = (Integer)iterator.next();
            WriterBuffer wb = this.buffers.get(partitionId);
            if (wb == null) {
                LOG.warn("get partition buffer failed,this should not happen!");
                continue;
            }
            dataSize += (long)wb.getDataLength();
            memoryUsed += (long)wb.getMemoryUsed();
            result.add(this.createShuffleBlock(partitionId, wb));
            this.recordCounter.addAndGet(wb.getRecordCount());
            this.copyTime += wb.getCopyTime();
            this.buffers.remove(partitionId);
            if (memoryUsed < targetSpillSize) continue;
            break;
        }
        LOG.info("Flush total buffer for shuffleId[" + this.shuffleId + "] with allocated[" + this.allocatedBytes + "], dataSize[" + dataSize + "], memoryUsed[" + memoryUsed + "], number of blocks[" + result.size() + "], flush ratio[" + bufferSpillRatio + "]");
        return result;
    }

    protected ShuffleBlockInfo createDeferredCompressedBlock(int partitionId, WriterBuffer writerBuffer) {
        byte[] data = writerBuffer.getData();
        int uncompressLength = data.length;
        int memoryUsed = writerBuffer.getMemoryUsed();
        this.blockCounter.incrementAndGet();
        this.uncompressedDataLen += (long)uncompressLength;
        this.inSendListBytes.addAndGet(memoryUsed);
        long blockId = this.blockIdLayout.getBlockId(this.getNextSeqNo(partitionId), partitionId, this.taskAttemptId);
        Function<DeferredCompressedBlock, DeferredCompressedBlock> rebuildFunction = block -> {
            byte[] compressed = data;
            if (this.codec.isPresent()) {
                long start = System.currentTimeMillis();
                compressed = this.codec.get().compress(data);
                this.compressTime += System.currentTimeMillis() - start;
            }
            this.compressedDataLen += (long)compressed.length;
            this.shuffleWriteMetrics.incBytesWritten((long)compressed.length);
            long crc32 = ChecksumUtils.getCrc32(compressed);
            block.reset(compressed, compressed.length, crc32);
            return block;
        };
        int estimatedCompressedSize = data.length;
        if (this.codec.isPresent()) {
            estimatedCompressedSize = this.codec.get().maxCompressedLength(data.length);
        }
        return new DeferredCompressedBlock(this.shuffleId, partitionId, blockId, this.partitionAssignmentRetrieveFunc.apply(partitionId), uncompressLength, memoryUsed, this.taskAttemptId, this.partitionAssignmentRetrieveFunc, rebuildFunction, estimatedCompressedSize);
    }

    protected ShuffleBlockInfo createShuffleBlock(int partitionId, WriterBuffer wb) {
        if (this.overlappingCompressionEnabled) {
            return this.createDeferredCompressedBlock(partitionId, wb);
        }
        byte[] data = wb.getData();
        int uncompressLength = data.length;
        byte[] compressed = data;
        if (this.codec.isPresent()) {
            long start = System.currentTimeMillis();
            compressed = this.codec.get().compress(data);
            this.compressTime += System.currentTimeMillis() - start;
        }
        long crc32 = ChecksumUtils.getCrc32(compressed);
        long blockId = this.blockIdLayout.getBlockId(this.getNextSeqNo(partitionId), partitionId, this.taskAttemptId);
        this.blockCounter.incrementAndGet();
        this.uncompressedDataLen += (long)data.length;
        this.compressedDataLen += (long)compressed.length;
        this.shuffleWriteMetrics.incBytesWritten((long)compressed.length);
        this.inSendListBytes.addAndGet(wb.getMemoryUsed());
        return new ShuffleBlockInfo(this.shuffleId, partitionId, blockId, compressed.length, crc32, compressed, this.partitionAssignmentRetrieveFunc.apply(partitionId), uncompressLength, wb.getMemoryUsed(), this.taskAttemptId, this.partitionAssignmentRetrieveFunc);
    }

    private int getNextSeqNo(int partitionId) {
        return this.partitionToSeqNo.computeIfAbsent(partitionId, k -> new AtomicInteger(0)).getAndIncrement();
    }

    private void requestMemory(long requiredMem) {
        long start = System.currentTimeMillis();
        if (this.allocatedBytes.get() - this.usedBytes.get() < requiredMem) {
            this.requestExecutorMemory(requiredMem);
        }
        this.requireMemoryTime += System.currentTimeMillis() - start;
    }

    private void requestExecutorMemory(long leastMem) {
        long gotMem = this.acquireMemory(this.askExecutorMemory);
        this.allocatedBytes.addAndGet(gotMem);
        int retry = 0;
        while (this.allocatedBytes.get() - this.usedBytes.get() < leastMem) {
            LOG.info("Can't get memory for now, sleep and try[" + retry + "] again, request[" + this.askExecutorMemory + "], got[" + gotMem + "] less than " + leastMem);
            try {
                Thread.sleep(this.requireMemoryInterval);
            }
            catch (InterruptedException ie) {
                throw new RssException("Interrupted when waiting for memory.", ie);
            }
            gotMem = this.acquireMemory(this.askExecutorMemory);
            this.allocatedBytes.addAndGet(gotMem);
            if (++retry <= this.requireMemoryRetryMax) continue;
            this.taskMemoryManager.showMemoryUsage();
            String message = "Can't get memory to cache shuffle data, request[" + this.askExecutorMemory + "], got[" + gotMem + "], WriteBufferManager allocated[" + this.allocatedBytes + "] task used[" + this.used + "]. It may be caused by shuffle server is full of data or consider to optimize 'spark.executor.memory', 'spark.rss.writer.buffer.spill.size'.";
            LOG.error(message);
            throw new RssException(message);
        }
    }

    public void releaseBlockResource(ShuffleBlockInfo block) {
        this.freeAllocatedMemory(block.getFreeMemory());
        block.getData().release();
    }

    private int getBlockLayoutLength(ShuffleBlockInfo block) {
        if (block instanceof DeferredCompressedBlock) {
            return ((DeferredCompressedBlock)block).getEstimatedLayoutSize();
        }
        return block.getSize();
    }

    public List<AddBlockEvent> buildBlockEvents(List<ShuffleBlockInfo> shuffleBlockInfoList) {
        long totalSize = 0L;
        ArrayList<AddBlockEvent> events = new ArrayList<AddBlockEvent>();
        List shuffleBlockInfosPerEvent = Lists.newArrayList();
        for (ShuffleBlockInfo sbi : shuffleBlockInfoList) {
            sbi.withCompletionCallback((block, isSuccessful) -> this.releaseBlockResource(block));
            shuffleBlockInfosPerEvent.add(sbi);
            if ((totalSize += (long)this.getBlockLayoutLength(sbi)) <= this.sendSizeLimit) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Build event with " + shuffleBlockInfosPerEvent.size() + " blocks and " + totalSize + " bytes");
            }
            events.add(new AddBlockEvent(this.taskId, this.stageAttemptNumber, shuffleBlockInfosPerEvent, this));
            shuffleBlockInfosPerEvent = Lists.newArrayList();
            totalSize = 0L;
        }
        if (!shuffleBlockInfosPerEvent.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Build event with " + shuffleBlockInfosPerEvent.size() + " blocks and " + totalSize + " bytes");
            }
            events.add(new AddBlockEvent(this.taskId, this.stageAttemptNumber, shuffleBlockInfosPerEvent, this));
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long spill(long size, MemoryConsumer trigger) {
        if (!this.memorySpillEnabled || trigger != this) {
            return 0L;
        }
        List<CompletableFuture<Long>> futures = this.spillFunc.apply(this.clear(this.bufferSpillRatio));
        CompletableFuture<Void> allOfFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        try {
            allOfFutures.get(this.memorySpillTimeoutSec, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            LOG.warn("[taskId: {}] Spill tasks timeout after {} seconds", (Object)this.taskId, (Object)this.memorySpillTimeoutSec);
        }
        catch (Exception e) {
            LOG.warn("[taskId: {}] Failed to spill buffers due to ", (Object)this.taskId, (Object)e);
        }
        finally {
            long releasedSize = futures.stream().filter(x -> x.isDone()).mapToLong(x -> {
                try {
                    return (Long)x.get();
                }
                catch (Exception e) {
                    return 0L;
                }
            }).sum();
            LOG.info("[taskId: {}] Spill triggered by own, released memory size: {}", (Object)this.taskId, (Object)releasedSize);
            return releasedSize;
        }
    }

    @VisibleForTesting
    protected long getAllocatedBytes() {
        return this.allocatedBytes.get();
    }

    @VisibleForTesting
    protected long getUsedBytes() {
        return this.usedBytes.get();
    }

    @VisibleForTesting
    protected long getInSendListBytes() {
        return this.inSendListBytes.get();
    }

    protected long getRecordCount() {
        return this.recordCounter.get();
    }

    public long getBlockCount() {
        return this.blockCounter.get();
    }

    public void freeAllocatedMemory(long freeMemory) {
        this.freeMemory(freeMemory);
        this.allocatedBytes.addAndGet(-freeMemory);
        this.usedBytes.addAndGet(-freeMemory);
        this.inSendListBytes.addAndGet(-freeMemory);
    }

    public void freeAllMemory() {
        long memory = this.allocatedBytes.get();
        if (memory > 0L) {
            this.freeMemory(memory);
        }
    }

    @VisibleForTesting
    protected Map<Integer, WriterBuffer> getBuffers() {
        return this.buffers;
    }

    @VisibleForTesting
    protected ShuffleWriteMetrics getShuffleWriteMetrics() {
        return this.shuffleWriteMetrics;
    }

    @VisibleForTesting
    protected void setShuffleWriteMetrics(ShuffleWriteMetrics shuffleWriteMetrics) {
        this.shuffleWriteMetrics = shuffleWriteMetrics;
    }

    public long getWriteTime() {
        return this.writeTime;
    }

    public long getCopyTime() {
        return this.copyTime;
    }

    public long getSerializeTime() {
        return this.serializeTime;
    }

    public long getCompressTime() {
        return this.compressTime;
    }

    public long getSortTime() {
        return this.sortTime;
    }

    public long getRequireMemoryTime() {
        return this.requireMemoryTime;
    }

    public String getManagerCostInfo() {
        return "WriteBufferManager cost copyTime[" + this.copyTime + "], writeTime[" + this.writeTime + "], serializeTime[" + this.serializeTime + "], sortTime[" + this.sortTime + "], estimateTime[" + this.estimateTime + "], requireMemoryTime[" + this.requireMemoryTime + "], uncompressedDataLen[" + this.uncompressedDataLen + "], compressedDataLen[" + this.compressedDataLen + "], compressTime[" + this.compressTime + "], compressRatio[" + (this.compressedDataLen == 0L ? 0.0f : (float)this.uncompressedDataLen / (float)this.compressedDataLen) + "]";
    }

    @VisibleForTesting
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @VisibleForTesting
    public void setSpillFunc(Function<List<ShuffleBlockInfo>, List<CompletableFuture<Long>>> spillFunc) {
        this.spillFunc = spillFunc;
    }

    @VisibleForTesting
    public void setSendSizeLimit(long sendSizeLimit) {
        this.sendSizeLimit = sendSizeLimit;
    }

    public void setPartitionAssignmentRetrieveFunc(Function<Integer, List<ShuffleServerInfo>> partitionAssignmentRetrieveFunc) {
        this.partitionAssignmentRetrieveFunc = partitionAssignmentRetrieveFunc;
    }

    public void merge(ShuffleServerPushCostTracker shuffleServerPushCostTracker) {
        this.shuffleServerPushCostTracker.merge(shuffleServerPushCostTracker);
    }

    public ShuffleServerPushCostTracker getShuffleServerPushCostTracker() {
        return this.shuffleServerPushCostTracker;
    }

    public void close() {
        try {
            Codec internalCodec;
            if (this.codec.isPresent() && (internalCodec = this.codec.get()) instanceof StatisticsCodec) {
                ((StatisticsCodec)internalCodec).statistics();
            }
        }
        catch (Exception e) {
            LOG.error("Errors on closing buffer manager", (Throwable)e);
        }
    }

    public long getUncompressedDataLen() {
        return this.uncompressedDataLen;
    }
}

