/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uniffle.common.ShuffleServerInfo;

public class PartitionDataReplicaRequirementTracking {
    private int shuffleId;
    private Map<Integer, Map<Integer, List<ShuffleServerInfo>>> inventory;
    private Map<Integer, Map<Integer, Integer>> succeedList = new HashMap<Integer, Map<Integer, Integer>>();

    public PartitionDataReplicaRequirementTracking(int shuffleId, Map<Integer, Map<Integer, List<ShuffleServerInfo>>> inventory) {
        this.shuffleId = shuffleId;
        this.inventory = inventory;
    }

    public PartitionDataReplicaRequirementTracking(Map<Integer, List<ShuffleServerInfo>> partitionToServers, int shuffleId) {
        this.shuffleId = shuffleId;
        this.inventory = this.toPartitionReplicaServers(partitionToServers);
    }

    private Map<Integer, Map<Integer, List<ShuffleServerInfo>>> toPartitionReplicaServers(Map<Integer, List<ShuffleServerInfo>> partitionToServers) {
        HashMap<Integer, Map<Integer, List<ShuffleServerInfo>>> inventory = new HashMap<Integer, Map<Integer, List<ShuffleServerInfo>>>();
        for (Map.Entry<Integer, List<ShuffleServerInfo>> entry : partitionToServers.entrySet()) {
            int partitionId = entry.getKey();
            Map replicas = inventory.computeIfAbsent(partitionId, x -> new HashMap());
            for (int i = 0; i < entry.getValue().size(); ++i) {
                replicas.computeIfAbsent(i, x -> new ArrayList()).add(entry.getValue().get(i));
            }
        }
        return inventory;
    }

    public boolean isSatisfied(int partitionId, int minReplica) {
        Map<Integer, Integer> succeedReplicas = this.succeedList.get(partitionId);
        if (succeedReplicas == null) {
            succeedReplicas = new HashMap<Integer, Integer>();
        }
        Map<Integer, List<ShuffleServerInfo>> replicaList = this.inventory.get(partitionId);
        int replicaSuccessfulCnt = 0;
        for (Map.Entry<Integer, Integer> succeedReplica : succeedReplicas.entrySet()) {
            int expected;
            int replicaIndex = succeedReplica.getKey();
            int succeedCnt = succeedReplica.getValue();
            if (succeedCnt < (expected = replicaList.get(replicaIndex).size())) continue;
            ++replicaSuccessfulCnt;
        }
        return replicaSuccessfulCnt >= minReplica;
    }

    public void markPartitionOfServerSuccessful(int partitionId, ShuffleServerInfo server) {
        Map partitionRequirements = this.succeedList.computeIfAbsent(partitionId, l -> new HashMap());
        Map<Integer, List<ShuffleServerInfo>> replicaServerChains = this.inventory.get(partitionId);
        for (Map.Entry<Integer, List<ShuffleServerInfo>> entry : replicaServerChains.entrySet()) {
            int replicaIdx = entry.getKey();
            if (!entry.getValue().contains(server)) continue;
            int old = partitionRequirements.computeIfAbsent(replicaIdx, x -> 0);
            partitionRequirements.put(replicaIdx, old + 1);
        }
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public Map<Integer, Map<Integer, List<ShuffleServerInfo>>> getInventory() {
        return this.inventory;
    }

    public String toString() {
        return "PartitionDataReplicaRequirementTracking{shuffleId=" + this.shuffleId + ", inventory=" + this.inventory + ", succeedList=" + this.succeedList + '}';
    }
}

