/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.impl.grpc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.uniffle.client.api.CoordinatorClient;
import org.apache.uniffle.client.impl.grpc.GrpcClient;
import org.apache.uniffle.client.request.RssAccessClusterRequest;
import org.apache.uniffle.client.request.RssAppHeartBeatRequest;
import org.apache.uniffle.client.request.RssApplicationInfoRequest;
import org.apache.uniffle.client.request.RssFetchClientConfRequest;
import org.apache.uniffle.client.request.RssFetchRemoteStorageRequest;
import org.apache.uniffle.client.request.RssGetShuffleAssignmentsRequest;
import org.apache.uniffle.client.request.RssSendHeartBeatRequest;
import org.apache.uniffle.client.response.RssAccessClusterResponse;
import org.apache.uniffle.client.response.RssAppHeartBeatResponse;
import org.apache.uniffle.client.response.RssApplicationInfoResponse;
import org.apache.uniffle.client.response.RssFetchClientConfResponse;
import org.apache.uniffle.client.response.RssFetchRemoteStorageResponse;
import org.apache.uniffle.client.response.RssGetShuffleAssignmentsResponse;
import org.apache.uniffle.client.response.RssSendHeartBeatResponse;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.storage.StorageInfoUtils;
import org.apache.uniffle.common.util.Constants;
import org.apache.uniffle.proto.CoordinatorServerGrpc;
import org.apache.uniffle.proto.RssProtos;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.com.google.common.collect.Maps;
import org.apache.uniffle.shaded.com.google.protobuf.Empty;
import org.apache.uniffle.shaded.io.grpc.ManagedChannel;
import org.apache.uniffle.shaded.io.grpc.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorGrpcClient
extends GrpcClient
implements CoordinatorClient {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinatorGrpcClient.class);
    private CoordinatorServerGrpc.CoordinatorServerBlockingStub blockingStub;

    public CoordinatorGrpcClient(String host, int port) {
        this(host, port, 3);
    }

    public CoordinatorGrpcClient(String host, int port, int maxRetryAttempts) {
        this(host, port, maxRetryAttempts, true);
    }

    public CoordinatorGrpcClient(String host, int port, int maxRetryAttempts, boolean usePlaintext) {
        super(host, port, maxRetryAttempts, usePlaintext);
        this.blockingStub = CoordinatorServerGrpc.newBlockingStub(this.channel);
        LOG.info("Created CoordinatorGrpcClient, host:{}, port:{}, maxRetryAttempts:{}, usePlaintext:{}", new Object[]{host, port, maxRetryAttempts, usePlaintext});
    }

    public CoordinatorGrpcClient(ManagedChannel channel) {
        super(channel);
        this.blockingStub = CoordinatorServerGrpc.newBlockingStub(channel);
    }

    @Override
    public String getDesc() {
        return "Coordinator grpc client ref to " + this.host + ":" + this.port;
    }

    public RssProtos.GetShuffleServerListResponse getShuffleServerList() {
        return this.blockingStub.getShuffleServerList(Empty.newBuilder().build());
    }

    public RssProtos.ShuffleServerHeartBeatResponse doSendHeartBeat(RssSendHeartBeatRequest rssRequest) {
        RssProtos.StatusCode status;
        RssProtos.ShuffleServerId serverId = RssProtos.ShuffleServerId.newBuilder().setId(rssRequest.getShuffleServerId()).setIp(rssRequest.getShuffleServerIp()).setPort(rssRequest.getShuffleServerPort()).setNettyPort(rssRequest.getNettyPort()).setJettyPort(rssRequest.getJettyPort()).build();
        RssProtos.ShuffleServerHeartBeatRequest request = RssProtos.ShuffleServerHeartBeatRequest.newBuilder().setServerId(serverId).setUsedMemory(rssRequest.getUsedMemory()).setPreAllocatedMemory(rssRequest.getPreAllocatedMemory()).setAvailableMemory(rssRequest.getAvailableMemory()).setEventNumInFlush(rssRequest.getEventNumInFlush()).addAllTags(rssRequest.getTags()).setStatusValue(rssRequest.getServerStatus().ordinal()).putAllStorageInfo(StorageInfoUtils.toProto(rssRequest.getStorageInfo())).setStartTimeMs(rssRequest.getStartTimeMs()).setVersion("0.10.0").setGitCommitId(Constants.REVISION_SHORT).addAllApplicationInfo(rssRequest.getAppInfos()).putAllDisplayMetrics(rssRequest.getDisplayMetrics()).build();
        RssProtos.ShuffleServerHeartBeatResponse response = null;
        try {
            response = ((CoordinatorServerGrpc.CoordinatorServerBlockingStub)this.blockingStub.withDeadlineAfter(rssRequest.getTimeout(), TimeUnit.MILLISECONDS)).heartbeat(request);
            status = response.getStatus();
        }
        catch (StatusRuntimeException e) {
            LOG.error("Failed to doSendHeartBeat, request: {}", (Object)request, (Object)e);
            status = RssProtos.StatusCode.TIMEOUT;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            status = RssProtos.StatusCode.INTERNAL_ERROR;
        }
        if (response == null) {
            response = RssProtos.ShuffleServerHeartBeatResponse.newBuilder().setStatus(status).build();
        }
        if (status != RssProtos.StatusCode.SUCCESS) {
            LOG.error("Fail to send heartbeat to {}:{} {}", new Object[]{this.host, this.port, status});
        }
        return response;
    }

    public RssProtos.GetShuffleAssignmentsResponse doGetShuffleAssignments(String appId, int shuffleId, int numMaps, int partitionNumPerRange, int dataReplica, Set<String> requiredTags, int assignmentShuffleServerNumber, int estimateTaskConcurrency, Set<String> faultyServerIds) {
        RssProtos.GetShuffleServerRequest getServerRequest = RssProtos.GetShuffleServerRequest.newBuilder().setApplicationId(appId).setShuffleId(shuffleId).setPartitionNum(numMaps).setPartitionNumPerRange(partitionNumPerRange).setDataReplica(dataReplica).addAllRequireTags(requiredTags).setAssignmentShuffleServerNumber(assignmentShuffleServerNumber).setEstimateTaskConcurrency(estimateTaskConcurrency).addAllFaultyServerIds(faultyServerIds).build();
        return this.blockingStub.getShuffleAssignments(getServerRequest);
    }

    @Override
    public RssSendHeartBeatResponse sendHeartBeat(RssSendHeartBeatRequest request) {
        RssSendHeartBeatResponse response;
        RssProtos.ShuffleServerHeartBeatResponse rpcResponse = this.doSendHeartBeat(request);
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssSendHeartBeatResponse(StatusCode.SUCCESS);
                break;
            }
            case TIMEOUT: {
                response = new RssSendHeartBeatResponse(StatusCode.TIMEOUT);
                break;
            }
            default: {
                response = new RssSendHeartBeatResponse(StatusCode.INTERNAL_ERROR);
            }
        }
        return response;
    }

    @Override
    public RssAppHeartBeatResponse scheduleAtFixedRateToSendAppHeartBeat(RssAppHeartBeatRequest request) {
        RssAppHeartBeatResponse response;
        RssProtos.AppHeartBeatRequest rpcRequest = RssProtos.AppHeartBeatRequest.newBuilder().setAppId(request.getAppId()).build();
        RssProtos.AppHeartBeatResponse rpcResponse = ((CoordinatorServerGrpc.CoordinatorServerBlockingStub)this.blockingStub.withDeadlineAfter(request.getTimeoutMs(), TimeUnit.MILLISECONDS)).appHeartbeat(rpcRequest);
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssAppHeartBeatResponse(StatusCode.SUCCESS);
                break;
            }
            default: {
                response = new RssAppHeartBeatResponse(StatusCode.INTERNAL_ERROR);
            }
        }
        return response;
    }

    @Override
    public RssApplicationInfoResponse registerApplicationInfo(RssApplicationInfoRequest request) {
        RssApplicationInfoResponse response;
        RssProtos.ApplicationInfoRequest rpcRequest = RssProtos.ApplicationInfoRequest.newBuilder().setAppId(request.getAppId()).setUser(request.getUser()).setVersion("0.10.0").setGitCommitId(Constants.REVISION_SHORT).build();
        RssProtos.ApplicationInfoResponse rpcResponse = ((CoordinatorServerGrpc.CoordinatorServerBlockingStub)this.blockingStub.withDeadlineAfter(request.getTimeoutMs(), TimeUnit.MILLISECONDS)).registerApplicationInfo(rpcRequest);
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssApplicationInfoResponse(StatusCode.SUCCESS);
                break;
            }
            default: {
                response = new RssApplicationInfoResponse(StatusCode.INTERNAL_ERROR);
            }
        }
        return response;
    }

    @Override
    public RssGetShuffleAssignmentsResponse getShuffleAssignments(RssGetShuffleAssignmentsRequest request) {
        RssGetShuffleAssignmentsResponse response;
        RssProtos.GetShuffleAssignmentsResponse rpcResponse = this.doGetShuffleAssignments(request.getAppId(), request.getShuffleId(), request.getPartitionNum(), request.getPartitionNumPerRange(), request.getDataReplica(), request.getRequiredTags(), request.getAssignmentShuffleServerNumber(), request.getEstimateTaskConcurrency(), request.getFaultyServerIds());
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssGetShuffleAssignmentsResponse(StatusCode.SUCCESS);
                Map<ShuffleServerInfo, List<PartitionRange>> serverToPartitionRanges = this.getServerToPartitionRanges(rpcResponse);
                Map<Integer, List<ShuffleServerInfo>> partitionToServers = this.getPartitionToServers(rpcResponse);
                response.setServerToPartitionRanges(serverToPartitionRanges);
                response.setPartitionToServers(partitionToServers);
                break;
            }
            case TIMEOUT: {
                response = new RssGetShuffleAssignmentsResponse(StatusCode.TIMEOUT);
                break;
            }
            default: {
                response = new RssGetShuffleAssignmentsResponse(StatusCode.INTERNAL_ERROR, rpcResponse.getRetMsg());
            }
        }
        return response;
    }

    @Override
    public RssAccessClusterResponse accessCluster(RssAccessClusterRequest request) {
        RssAccessClusterResponse response;
        RssProtos.AccessClusterResponse rpcResponse;
        RssProtos.AccessClusterRequest rpcRequest = RssProtos.AccessClusterRequest.newBuilder().setAccessId(request.getAccessId()).setUser(request.getUser()).addAllTags(request.getTags()).putAllExtraProperties(request.getExtraProperties()).build();
        try {
            rpcResponse = ((CoordinatorServerGrpc.CoordinatorServerBlockingStub)this.blockingStub.withDeadlineAfter(request.getTimeoutMs(), TimeUnit.MILLISECONDS)).accessCluster(rpcRequest);
        }
        catch (Exception e) {
            return new RssAccessClusterResponse(StatusCode.INTERNAL_ERROR, e.getMessage());
        }
        RssProtos.StatusCode statusCode = rpcResponse.getStatus();
        switch (statusCode) {
            case SUCCESS: {
                response = new RssAccessClusterResponse(StatusCode.SUCCESS, rpcResponse.getRetMsg(), rpcResponse.getUuid());
                break;
            }
            default: {
                response = new RssAccessClusterResponse(StatusCode.ACCESS_DENIED, rpcResponse.getRetMsg());
            }
        }
        return response;
    }

    @Override
    public RssFetchClientConfResponse fetchClientConf(RssFetchClientConfRequest request) {
        try {
            RssProtos.FetchClientConfResponse rpcResponse = ((CoordinatorServerGrpc.CoordinatorServerBlockingStub)this.blockingStub.withDeadlineAfter(request.getTimeoutMs(), TimeUnit.MILLISECONDS)).fetchClientConfV2(request.toProto());
            Map<String, String> clientConf = rpcResponse.getClientConfList().stream().collect(Collectors.toMap(RssProtos.ClientConfItem::getKey, RssProtos.ClientConfItem::getValue));
            return new RssFetchClientConfResponse(StatusCode.SUCCESS, rpcResponse.getRetMsg(), clientConf);
        }
        catch (Exception e) {
            LOG.info(e.getMessage(), (Throwable)e);
            return new RssFetchClientConfResponse(StatusCode.INTERNAL_ERROR, e.getMessage());
        }
    }

    @Override
    public RssFetchRemoteStorageResponse fetchRemoteStorage(RssFetchRemoteStorageRequest request) {
        RssProtos.FetchRemoteStorageRequest rpcRequest = RssProtos.FetchRemoteStorageRequest.newBuilder().setAppId(request.getAppId()).build();
        try {
            RssProtos.FetchRemoteStorageResponse rpcResponse = this.blockingStub.fetchRemoteStorage(rpcRequest);
            Map<String, String> remoteStorageConf = rpcResponse.getRemoteStorage().getRemoteStorageConfList().stream().collect(Collectors.toMap(RssProtos.RemoteStorageConfItem::getKey, RssProtos.RemoteStorageConfItem::getValue));
            RssFetchRemoteStorageResponse tt = new RssFetchRemoteStorageResponse(StatusCode.SUCCESS, new RemoteStorageInfo(rpcResponse.getRemoteStorage().getPath(), remoteStorageConf));
            return tt;
        }
        catch (Exception e) {
            LOG.info("Failed to fetch remote storage from coordinator, " + e.getMessage(), (Throwable)e);
            return new RssFetchRemoteStorageResponse(StatusCode.INTERNAL_ERROR, null);
        }
    }

    @VisibleForTesting
    public Map<Integer, List<ShuffleServerInfo>> getPartitionToServers(RssProtos.GetShuffleAssignmentsResponse response) {
        HashMap<Integer, List<ShuffleServerInfo>> partitionToServers = Maps.newHashMap();
        List<RssProtos.PartitionRangeAssignment> assigns = response.getAssignmentsList();
        for (RssProtos.PartitionRangeAssignment partitionRangeAssignment : assigns) {
            int startPartition = partitionRangeAssignment.getStartPartition();
            int endPartition = partitionRangeAssignment.getEndPartition();
            List shuffleServerInfos = partitionRangeAssignment.getServerList().stream().map(ss -> new ShuffleServerInfo(ss.getId(), ss.getIp(), ss.getPort(), ss.getNettyPort())).collect(Collectors.toList());
            for (int i = startPartition; i <= endPartition; ++i) {
                partitionToServers.put(i, shuffleServerInfos);
            }
        }
        if (partitionToServers.isEmpty()) {
            throw new RssException("Empty assignment to Shuffle Server");
        }
        return partitionToServers;
    }

    @VisibleForTesting
    public Map<ShuffleServerInfo, List<PartitionRange>> getServerToPartitionRanges(RssProtos.GetShuffleAssignmentsResponse response) {
        HashMap<ShuffleServerInfo, List<PartitionRange>> serverToPartitionRanges = Maps.newHashMap();
        List<RssProtos.PartitionRangeAssignment> assigns = response.getAssignmentsList();
        for (RssProtos.PartitionRangeAssignment assign : assigns) {
            List<RssProtos.ShuffleServerId> shuffleServerIds = assign.getServerList();
            if (shuffleServerIds == null) continue;
            PartitionRange partitionRange = new PartitionRange(assign.getStartPartition(), assign.getEndPartition());
            for (RssProtos.ShuffleServerId ssi : shuffleServerIds) {
                ShuffleServerInfo shuffleServerInfo = new ShuffleServerInfo(ssi.getId(), ssi.getIp(), ssi.getPort(), ssi.getNettyPort());
                if (!serverToPartitionRanges.containsKey(shuffleServerInfo)) {
                    serverToPartitionRanges.put(shuffleServerInfo, Lists.newArrayList());
                }
                ((List)serverToPartitionRanges.get(shuffleServerInfo)).add(partitionRange);
            }
        }
        return serverToPartitionRanges;
    }
}

