/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.executor;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.uniffle.common.ReconfigurableRegistry;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.executor.MeasurableRejectedExecutionHandler;
import org.apache.uniffle.common.metrics.CommonMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolManager {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolManager.class);
    private static final Map<Object, MeasurableThreadPoolExecutor> THREAD_POOL_MAP = new ConcurrentHashMap<Object, MeasurableThreadPoolExecutor>();

    @VisibleForTesting
    public static ThreadPoolExecutor newThreadPool(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        return ThreadPoolManager.newThreadPool(name, () -> corePoolSize, () -> maximumPoolSize, () -> keepAliveTime, unit, workQueue, threadFactory);
    }

    @VisibleForTesting
    public static ThreadPoolExecutor newThreadPool(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        return ThreadPoolManager.newThreadPool(name, () -> corePoolSize, () -> maximumPoolSize, () -> keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public static ThreadPoolExecutor newThreadPool(String name, Supplier<Integer> corePoolSizeSupplier, Supplier<Integer> maximumPoolSizeSupplier, Supplier<Long> keepAliveTimeSupplier, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor((int)corePoolSizeSupplier.get(), (int)maximumPoolSizeSupplier.get(), (long)keepAliveTimeSupplier.get(), unit, workQueue, threadFactory);
        ThreadPoolManager.registerThreadPool(name, corePoolSizeSupplier, maximumPoolSizeSupplier, () -> (Long)keepAliveTimeSupplier.get() * unit.toMillis(1L), threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ThreadPoolExecutor newThreadPool(String name, Supplier<Integer> corePoolSizeSupplier, Supplier<Integer> maximumPoolSizeSupplier, Supplier<Long> keepAliveTimeSupplier, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSizeSupplier.get(), maximumPoolSizeSupplier.get(), keepAliveTimeSupplier.get(), unit, workQueue, threadFactory, handler);
        ThreadPoolManager.registerThreadPool(name, corePoolSizeSupplier, maximumPoolSizeSupplier, keepAliveTimeSupplier, threadPoolExecutor);
        return threadPoolExecutor;
    }

    @VisibleForTesting
    public static void registerThreadPool(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, ThreadPoolExecutor threadPoolExecutor) {
        ThreadPoolManager.registerThreadPool(name, () -> corePoolSize, () -> maximumPoolSize, () -> keepAliveTime, threadPoolExecutor);
    }

    public static void registerThreadPool(String name, Supplier<Integer> corePoolSizeSupplier, Supplier<Integer> maximumPoolSizeSupplier, Supplier<Long> keepAliveTimeSupplier, ThreadPoolExecutor threadPoolExecutor) {
        THREAD_POOL_MAP.put(threadPoolExecutor, new MeasurableThreadPoolExecutor(name, threadPoolExecutor, corePoolSizeSupplier, maximumPoolSizeSupplier, keepAliveTimeSupplier));
        LOG.info("{} thread pool, core size:{}, max size:{}, keep alive time:{}", new Object[]{name, corePoolSizeSupplier, maximumPoolSizeSupplier, keepAliveTimeSupplier});
    }

    public static void unregister(Object key) {
        MeasurableThreadPoolExecutor measurableThreadPoolExecutor = THREAD_POOL_MAP.remove(key);
        if (measurableThreadPoolExecutor != null) {
            measurableThreadPoolExecutor.close();
        }
    }

    public static boolean exists(Object key) {
        return THREAD_POOL_MAP.containsKey(key);
    }

    @VisibleForTesting
    public static Map<Object, MeasurableThreadPoolExecutor> getThreadPoolMap() {
        return Collections.unmodifiableMap(THREAD_POOL_MAP);
    }

    @VisibleForTesting
    public static void clear() {
        for (MeasurableThreadPoolExecutor executor : THREAD_POOL_MAP.values()) {
            executor.close();
        }
        THREAD_POOL_MAP.clear();
    }

    @VisibleForTesting
    public static class MeasurableThreadPoolExecutor
    implements Closeable,
    ReconfigurableRegistry.ReconfigureListener {
        private final String name;
        private final ThreadPoolExecutor threadPoolExecutor;
        private final Supplier<Integer> corePoolSizeSupplier;
        private final Supplier<Integer> maximumPoolSizeSupplier;
        private final Supplier<Long> keepAliveTimeSupplier;

        MeasurableThreadPoolExecutor(String name, ThreadPoolExecutor threadPoolExecutor, Supplier<Integer> corePoolSizeSupplier, Supplier<Integer> maximumPoolSizeSupplier, Supplier<Long> keepAliveTimeSupplier) {
            this.name = name;
            this.threadPoolExecutor = threadPoolExecutor;
            this.corePoolSizeSupplier = corePoolSizeSupplier;
            this.maximumPoolSizeSupplier = maximumPoolSizeSupplier;
            this.keepAliveTimeSupplier = keepAliveTimeSupplier;
            MeasurableRejectedExecutionHandler measurableRejectedExecutionHandler = new MeasurableRejectedExecutionHandler(threadPoolExecutor.getRejectedExecutionHandler());
            threadPoolExecutor.setRejectedExecutionHandler(measurableRejectedExecutionHandler);
            CommonMetrics.addLabeledGauge(name + "_ThreadActiveCount", threadPoolExecutor::getActiveCount);
            CommonMetrics.addLabeledGauge(name + "_ThreadCurrentCount", threadPoolExecutor::getPoolSize);
            CommonMetrics.addLabeledGauge(name + "_ThreadMaxCount", threadPoolExecutor::getMaximumPoolSize);
            CommonMetrics.addLabeledGauge(name + "_ThreadMinCount", threadPoolExecutor::getCorePoolSize);
            CommonMetrics.addLabeledGauge(name + "_CompleteTaskCount", threadPoolExecutor::getCompletedTaskCount);
            CommonMetrics.addLabeledGauge(name + "_ThreadQueueWaitingTaskCount", threadPoolExecutor.getQueue()::size);
            CommonMetrics.addLabeledGauge(name + "_RejectCount", measurableRejectedExecutionHandler::getCount);
            ReconfigurableRegistry.register(this);
        }

        @VisibleForTesting
        public String getName() {
            return this.name;
        }

        @Override
        public void close() {
            ReconfigurableRegistry.unregister(this);
            CommonMetrics.unregisterSupplierGauge(this.name + "_ThreadActiveCount");
            CommonMetrics.unregisterSupplierGauge(this.name + "_ThreadCurrentCount");
            CommonMetrics.unregisterSupplierGauge(this.name + "_ThreadMaxCount");
            CommonMetrics.unregisterSupplierGauge(this.name + "_ThreadMinCount");
            CommonMetrics.unregisterSupplierGauge(this.name + "_CompleteTaskCount");
            CommonMetrics.unregisterSupplierGauge(this.name + "_ThreadQueueWaitingTaskCount");
            CommonMetrics.unregisterSupplierGauge(this.name + "_RejectCount");
        }

        @Override
        public void update(RssConf conf, Set<String> changedProperties) {
            long keepAliveTime;
            int newCorePoolSize = this.corePoolSizeSupplier.get();
            int newMaximumPoolSize = this.maximumPoolSizeSupplier.get();
            if (this.keepAliveTimeSupplier != null && (keepAliveTime = this.keepAliveTimeSupplier.get().longValue()) > 0L && keepAliveTime != this.threadPoolExecutor.getKeepAliveTime(TimeUnit.MILLISECONDS)) {
                LOG.info("Updated thread pool {} keep alive time from {} to {}", new Object[]{this.name, this.threadPoolExecutor.getKeepAliveTime(TimeUnit.MILLISECONDS), keepAliveTime});
                this.threadPoolExecutor.setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
            }
            if (newCorePoolSize != this.threadPoolExecutor.getPoolSize() && newMaximumPoolSize != this.threadPoolExecutor.getMaximumPoolSize()) {
                LOG.info("Updated thread pool {} MaximumPoolSize from {} to {}", new Object[]{this.name, this.threadPoolExecutor.getMaximumPoolSize(), newMaximumPoolSize});
                LOG.info("Updated thread pool {} CorePoolSize from {} to {}", new Object[]{this.name, this.threadPoolExecutor.getCorePoolSize(), newCorePoolSize});
                if (newCorePoolSize > this.threadPoolExecutor.getMaximumPoolSize()) {
                    this.threadPoolExecutor.setMaximumPoolSize(newMaximumPoolSize);
                    this.threadPoolExecutor.setCorePoolSize(newCorePoolSize);
                } else {
                    this.threadPoolExecutor.setCorePoolSize(newCorePoolSize);
                    this.threadPoolExecutor.setMaximumPoolSize(newMaximumPoolSize);
                }
            } else if (newMaximumPoolSize != this.threadPoolExecutor.getMaximumPoolSize()) {
                LOG.info("Updated thread pool {} MaximumPoolSize from {} to {}", new Object[]{this.name, this.threadPoolExecutor.getMaximumPoolSize(), newMaximumPoolSize});
                this.threadPoolExecutor.setMaximumPoolSize(newMaximumPoolSize);
            } else if (newCorePoolSize != this.threadPoolExecutor.getCorePoolSize()) {
                LOG.info("Updated thread pool {} CorePoolSize from {} to {}", new Object[]{this.name, this.threadPoolExecutor.getCorePoolSize(), newCorePoolSize});
                this.threadPoolExecutor.setCorePoolSize(newCorePoolSize);
            }
        }
    }
}

