/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.dashboard.web.proxy;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.proxy.ProxyServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebProxyServlet
extends ProxyServlet {
    private static final Logger LOG = LoggerFactory.getLogger(WebProxyServlet.class);
    private static final String HEADER_TARGET_ADDRESS = "targetAddress";
    private static final String HEADER_REQUEST_SERVER_TYPE = "requestServerType";
    private static final String REQUEST_SERVER_TYPE_COORDINATOR = "coordinator";
    private static final String REQUEST_SERVER_TYPE_SERVER = "server";
    private Map<String, String> coordinatorServerAddressesMap;

    public WebProxyServlet(Map<String, String> coordinatorServerAddressesMap) {
        Preconditions.checkArgument((!coordinatorServerAddressesMap.isEmpty() ? 1 : 0) != 0, (Object)"No coordinator server address found.");
        this.coordinatorServerAddressesMap = coordinatorServerAddressesMap;
    }

    protected String rewriteTarget(HttpServletRequest clientRequest) {
        if (!this.validateDestination(clientRequest.getServerName(), clientRequest.getServerPort())) {
            return null;
        }
        String requestServerType = clientRequest.getHeader(HEADER_REQUEST_SERVER_TYPE) != null && REQUEST_SERVER_TYPE_COORDINATOR.equalsIgnoreCase(clientRequest.getHeader(HEADER_REQUEST_SERVER_TYPE)) ? REQUEST_SERVER_TYPE_COORDINATOR : REQUEST_SERVER_TYPE_SERVER;
        String targetAddress = requestServerType.equalsIgnoreCase(REQUEST_SERVER_TYPE_COORDINATOR) ? this.coordinatorServerAddressesMap.get(clientRequest.getHeader(HEADER_TARGET_ADDRESS)) : clientRequest.getHeader(HEADER_TARGET_ADDRESS);
        StringBuilder target = new StringBuilder();
        target.append(targetAddress).append("/api").append(clientRequest.getPathInfo());
        String query = clientRequest.getQueryString();
        if (query != null) {
            target.append("?").append(query);
        }
        LOG.info(target.toString());
        return target.toString();
    }

    protected void onProxyResponseFailure(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Response serverResponse, Throwable failure) {
        this.sendProxyResponseError(clientRequest, proxyResponse, 403);
    }

    protected void onProxyRewriteFailed(HttpServletRequest clientRequest, HttpServletResponse proxyResponse) {
        this.sendProxyResponseError(clientRequest, proxyResponse, 403);
    }
}

