/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.uniffle.common.util.UnitConverter;

public class ShuffleDetailInfo {
    private int id;
    private AtomicLong dataSize;
    private AtomicLong blockCount;
    private AtomicLong partitionCount;
    private long startTime;

    public ShuffleDetailInfo(int id, long startTime) {
        this.id = id;
        this.dataSize = new AtomicLong();
        this.blockCount = new AtomicLong();
        this.partitionCount = new AtomicLong();
        this.startTime = startTime;
    }

    public int getId() {
        return this.id;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getBlockCount() {
        return this.blockCount.get();
    }

    public long getDataSize() {
        return this.dataSize.get();
    }

    public void incrDataSize(long size) {
        this.dataSize.addAndGet(size);
    }

    public void incrBlockCount(long count) {
        this.blockCount.addAndGet(count);
    }

    public void incrPartitionCount() {
        this.partitionCount.addAndGet(1L);
    }

    public String toString() {
        return String.format("ShuffleDetail [%d: partitionCount=%s, blockCount=%s, size=%s, startTime=%s]", this.id, this.partitionCount, this.blockCount, UnitConverter.formatSize((long)this.dataSize.get()), DateFormatUtils.format((long)this.startTime, (String)"yyyy-MM-dd HH:mm:ss"));
    }
}

