/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ElasticsearchVersionMinInfo
implements JsonpSerializable {
    private final String buildFlavor;
    private final String minimumIndexCompatibilityVersion;
    private final String minimumWireCompatibilityVersion;
    private final String number;
    public static final JsonpDeserializer<ElasticsearchVersionMinInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ElasticsearchVersionMinInfo::setupElasticsearchVersionMinInfoDeserializer);

    private ElasticsearchVersionMinInfo(Builder builder) {
        this.buildFlavor = ApiTypeHelper.requireNonNull(builder.buildFlavor, this, "buildFlavor");
        this.minimumIndexCompatibilityVersion = ApiTypeHelper.requireNonNull(builder.minimumIndexCompatibilityVersion, this, "minimumIndexCompatibilityVersion");
        this.minimumWireCompatibilityVersion = ApiTypeHelper.requireNonNull(builder.minimumWireCompatibilityVersion, this, "minimumWireCompatibilityVersion");
        this.number = ApiTypeHelper.requireNonNull(builder.number, this, "number");
    }

    public static ElasticsearchVersionMinInfo of(Function<Builder, ObjectBuilder<ElasticsearchVersionMinInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String buildFlavor() {
        return this.buildFlavor;
    }

    public final String minimumIndexCompatibilityVersion() {
        return this.minimumIndexCompatibilityVersion;
    }

    public final String minimumWireCompatibilityVersion() {
        return this.minimumWireCompatibilityVersion;
    }

    public final String number() {
        return this.number;
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("build_flavor");
        generator.write(this.buildFlavor);
        generator.writeKey("minimum_index_compatibility_version");
        generator.write(this.minimumIndexCompatibilityVersion);
        generator.writeKey("minimum_wire_compatibility_version");
        generator.write(this.minimumWireCompatibilityVersion);
        generator.writeKey("number");
        generator.write(this.number);
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    protected static void setupElasticsearchVersionMinInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::buildFlavor, JsonpDeserializer.stringDeserializer(), "build_flavor");
        op.add(Builder::minimumIndexCompatibilityVersion, JsonpDeserializer.stringDeserializer(), "minimum_index_compatibility_version");
        op.add(Builder::minimumWireCompatibilityVersion, JsonpDeserializer.stringDeserializer(), "minimum_wire_compatibility_version");
        op.add(Builder::number, JsonpDeserializer.stringDeserializer(), "number");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ElasticsearchVersionMinInfo> {
        private String buildFlavor;
        private String minimumIndexCompatibilityVersion;
        private String minimumWireCompatibilityVersion;
        private String number;

        public final Builder buildFlavor(String value) {
            this.buildFlavor = value;
            return this;
        }

        public final Builder minimumIndexCompatibilityVersion(String value) {
            this.minimumIndexCompatibilityVersion = value;
            return this;
        }

        public final Builder minimumWireCompatibilityVersion(String value) {
            this.minimumWireCompatibilityVersion = value;
            return this;
        }

        public final Builder number(String value) {
            this.number = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ElasticsearchVersionMinInfo build() {
            this._checkSingleUse();
            return new ElasticsearchVersionMinInfo(this);
        }
    }
}

