/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.ControlledShutdownResponse;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;

public abstract class AbstractResponse
extends AbstractRequestResponse {
    public static final String THROTTLE_TIME_KEY_NAME = "throttle_time_ms";
    public static final int DEFAULT_THROTTLE_TIME = 0;

    public Send toSend(String destination, RequestHeader requestHeader) {
        return this.toSend(destination, requestHeader.apiVersion(), requestHeader.toResponseHeader());
    }

    public Send toSend(String destination, short version, ResponseHeader responseHeader) {
        return new NetworkSend(destination, this.serialize(version, responseHeader));
    }

    public ByteBuffer serialize(short version, ResponseHeader responseHeader) {
        return AbstractResponse.serialize(responseHeader.toStruct(), this.toStruct(version));
    }

    protected abstract Struct toStruct(short var1);

    public static AbstractResponse getResponse(ApiKeys apiKey, Struct struct) {
        switch (apiKey) {
            case PRODUCE: {
                return new ProduceResponse(struct);
            }
            case FETCH: {
                return new FetchResponse(struct);
            }
            case LIST_OFFSETS: {
                return new ListOffsetResponse(struct);
            }
            case METADATA: {
                return new MetadataResponse(struct);
            }
            case OFFSET_COMMIT: {
                return new OffsetCommitResponse(struct);
            }
            case OFFSET_FETCH: {
                return new OffsetFetchResponse(struct);
            }
            case FIND_COORDINATOR: {
                return new FindCoordinatorResponse(struct);
            }
            case JOIN_GROUP: {
                return new JoinGroupResponse(struct);
            }
            case HEARTBEAT: {
                return new HeartbeatResponse(struct);
            }
            case LEAVE_GROUP: {
                return new LeaveGroupResponse(struct);
            }
            case SYNC_GROUP: {
                return new SyncGroupResponse(struct);
            }
            case STOP_REPLICA: {
                return new StopReplicaResponse(struct);
            }
            case CONTROLLED_SHUTDOWN_KEY: {
                return new ControlledShutdownResponse(struct);
            }
            case UPDATE_METADATA_KEY: {
                return new UpdateMetadataResponse(struct);
            }
            case LEADER_AND_ISR: {
                return new LeaderAndIsrResponse(struct);
            }
            case DESCRIBE_GROUPS: {
                return new DescribeGroupsResponse(struct);
            }
            case LIST_GROUPS: {
                return new ListGroupsResponse(struct);
            }
            case SASL_HANDSHAKE: {
                return new SaslHandshakeResponse(struct);
            }
            case API_VERSIONS: {
                return new ApiVersionsResponse(struct);
            }
            case CREATE_TOPICS: {
                return new CreateTopicsResponse(struct);
            }
            case DELETE_TOPICS: {
                return new DeleteTopicsResponse(struct);
            }
            case DELETE_RECORDS: {
                return new DeleteRecordsResponse(struct);
            }
            case INIT_PRODUCER_ID: {
                return new InitProducerIdResponse(struct);
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                return new OffsetsForLeaderEpochResponse(struct);
            }
            case ADD_PARTITIONS_TO_TXN: {
                return new AddPartitionsToTxnResponse(struct);
            }
            case ADD_OFFSETS_TO_TXN: {
                return new AddOffsetsToTxnResponse(struct);
            }
            case END_TXN: {
                return new EndTxnResponse(struct);
            }
            case WRITE_TXN_MARKERS: {
                return new WriteTxnMarkersResponse(struct);
            }
            case TXN_OFFSET_COMMIT: {
                return new TxnOffsetCommitResponse(struct);
            }
            case DESCRIBE_ACLS: {
                return new DescribeAclsResponse(struct);
            }
            case CREATE_ACLS: {
                return new CreateAclsResponse(struct);
            }
            case DELETE_ACLS: {
                return new DeleteAclsResponse(struct);
            }
            case DESCRIBE_CONFIGS: {
                return new DescribeConfigsResponse(struct);
            }
            case ALTER_CONFIGS: {
                return new AlterConfigsResponse(struct);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `getResponse`, the code should be updated to do so.", new Object[]{apiKey}));
    }

    public String toString(short version) {
        return this.toStruct(version).toString();
    }
}

