/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.bean.validation;

import jakarta.validation.Configuration;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.function.Supplier;
import org.apache.wicket.bean.validation.SessionLocaleInterpolator;

public class DefaultValidatorProvider
implements Supplier<Validator> {
    private Validator validator;

    @Override
    public Validator get() {
        if (this.validator == null) {
            Configuration config = Validation.byDefaultProvider().configure();
            MessageInterpolator interpolator = config.getDefaultMessageInterpolator();
            interpolator = new SessionLocaleInterpolator(interpolator);
            ValidatorFactory factory = config.messageInterpolator(interpolator).buildValidatorFactory();
            this.validator = factory.getValidator();
        }
        return this.validator;
    }
}

